/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityCustomFishingHook;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.network.S2CEntityDataSync;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class EntityData {
    private boolean sleeping;
    private boolean isSilent;
    private boolean paralysis;
    private boolean stunned;
    private boolean noAIStunned;
    private boolean cold;
    private boolean poison;
    private boolean invis;
    private boolean orthoView;
    private int disabledState;
    public EntityCustomFishingHook fishingHook;
    private ItemStack main;
    private ItemStack off;
    public float sleepYRot;
    private final HashSet<ResourceLocation> armorFlags = new HashSet();

    public static SleepState getSleepStateFrom(LivingEntity entity) {
        return Platform.INSTANCE.getEntityData(entity).map(e -> e.getSleepState(entity)).orElse(SleepState.NONE);
    }

    public SleepState getSleepState(LivingEntity entity) {
        SleepingEntity sleeping;
        if (!this.isSleeping()) {
            return SleepState.NONE;
        }
        if (entity instanceof SleepingEntity && (sleeping = (SleepingEntity)entity).hasSleepingAnimation()) {
            return SleepState.CUSTOM;
        }
        return SleepState.VANILLA;
    }

    public void setSleeping(LivingEntity entity, boolean flag) {
        this.sleeping = flag;
        this.updateAiState(entity, flag);
        this.setOrthoView(entity, flag);
        this.sleepYRot = entity.f_20883_;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.SLEEP, this.sleeping), (Entity)entity);
        } else {
            ClientHandlers.grabMouse(entity, this.sleeping);
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public void setPoison(LivingEntity entity, boolean flag) {
        this.poison = flag;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.POISON, this.poison), (Entity)entity);
        }
    }

    public boolean isPoisoned() {
        return this.poison;
    }

    public void setCold(LivingEntity entity, boolean flag) {
        this.cold = flag;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.COLD, this.cold), (Entity)entity);
        }
    }

    public boolean hasCold() {
        return this.cold;
    }

    public void setParalysis(LivingEntity entity, boolean flag) {
        this.paralysis = flag;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.PARALYSIS, this.paralysis), (Entity)entity);
        }
    }

    public boolean isParalysed() {
        return this.paralysis;
    }

    public void setStunned(LivingEntity entity, boolean flag) {
        this.stunned = flag;
        this.updateAiState(entity, flag);
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.STUN, this.stunned), (Entity)entity);
        }
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public void setInvis(LivingEntity entity, boolean flag) {
        this.invis = flag;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.INVIS, this.invis), (Entity)entity);
        }
    }

    public boolean isInvis() {
        return this.invis;
    }

    public void setOrthoView(LivingEntity entity, boolean flag) {
        this.orthoView = flag;
        if (!entity.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.m_142049_(), S2CEntityDataSync.Type.ORTHOVIEW, this.orthoView), (Entity)entity);
        } else {
            ClientHandlers.trySetPerspective(entity, flag);
        }
    }

    public boolean isOrthoView() {
        return this.orthoView;
    }

    public ItemStack getGloveOffHand(ItemStack stack) {
        if (stack != null && this.main != stack) {
            this.main = stack;
            this.off = this.main.m_41777_();
        }
        return this.off;
    }

    public void addArmorFlag(ResourceLocation key) {
        this.armorFlags.add(key);
    }

    public void removeArmorFlag(ResourceLocation key) {
        this.armorFlags.remove(key);
    }

    public boolean hasArmorFlag(ResourceLocation key) {
        return this.armorFlags.contains(key);
    }

    private void updateAiState(LivingEntity entity, boolean increase) {
        int pre = this.disabledState++;
        if (!increase) {
            --this.disabledState;
        }
        if (pre == 0 && increase) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.noAIStunned = mob.m_21525_();
                if (!this.noAIStunned) {
                    mob.m_21557_(true);
                }
            }
            this.isSilent = entity.m_20067_();
            if (!this.isSilent) {
                entity.m_20225_(true);
            }
        } else if (pre == 1 && !increase) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (!this.noAIStunned) {
                    mob.m_21557_(false);
                }
            }
            if (!this.isSilent) {
                entity.m_20225_(false);
            }
        }
    }

    public static enum SleepState {
        NONE,
        VANILLA,
        CUSTOM;

    }
}

