/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;

public class StaffData {
    private Spell tier1;
    private Spell tier2;
    private Spell tier3;
    private int chargeTime;

    public Spell getTier1Spell(ItemStack stack) {
        return this.tier1 != null ? this.tier1 : (Spell)DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::getTier1Spell).orElse(null);
    }

    public void setTier1Spell(Spell spell) {
        this.tier1 = spell;
        if (spell != null) {
            this.chargeTime = spell.coolDown();
        }
    }

    public Spell getTier2Spell(ItemStack stack) {
        return this.tier2 != null ? this.tier2 : (Spell)DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::getTier2Spell).orElse(null);
    }

    public void setTier2Spell(Spell spell) {
        this.tier2 = spell;
        if (spell != null && this.tier1 == null) {
            this.chargeTime = spell.coolDown();
        }
    }

    public Spell getTier3Spell(ItemStack stack) {
        return this.tier3 != null ? this.tier3 : (Spell)DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::getTier3Spell).orElse(null);
    }

    public void setTier3Spell(Spell spell) {
        this.tier3 = spell;
        if (spell != null && this.tier1 == null && this.tier2 == null) {
            this.chargeTime = spell.coolDown();
        }
    }

    public int getChargeTime() {
        return this.chargeTime == 0 ? (int)((Attribute)ModAttributes.CHARGE_TIME.get()).m_22082_() : this.chargeTime;
    }

    public void readFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Tier_1")) {
            this.tier1 = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("Tier_1"))));
        }
        if (nbt.m_128441_("Tier_2")) {
            this.tier2 = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("Tier_2"))));
        }
        if (nbt.m_128441_("Tier_3")) {
            this.tier3 = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("Tier_3"))));
        }
        this.chargeTime = nbt.m_128451_("ChargeTime");
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.tier1 != null) {
            nbt.m_128359_("Tier_1", this.tier1.getRegistryName().toString());
        }
        if (this.tier2 != null) {
            nbt.m_128359_("Tier_2", this.tier2.getRegistryName().toString());
        }
        if (this.tier3 != null) {
            nbt.m_128359_("Tier_3", this.tier3.getRegistryName().toString());
        }
        nbt.m_128405_("ChargeTime", this.chargeTime);
        return nbt;
    }
}

