/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DailyPlayerUpdater {
    private int lastUpdateDay = -1;
    private boolean gaveMonsterItem;
    private boolean ateFood;
    private int bathCounter;
    private final Random random = new Random();
    private int dailyRandomSeed;
    private final PlayerData data;

    public DailyPlayerUpdater(PlayerData data) {
        this.data = data;
    }

    public void tick(ServerPlayer player) {
        int day;
        if (this.dailyRandomSeed == 0) {
            this.dailyRandomSeed = player.m_21187_().nextInt();
        }
        if (this.lastUpdateDay != (day = WorldUtils.day(player.f_19853_))) {
            this.lastUpdateDay = day;
            this.data.getShippingInv().shipItems(player);
            this.data.refreshShop((Player)player);
            this.gaveMonsterItem = false;
            this.ateFood = false;
            this.bathCounter = 0;
            this.dailyRandomSeed = player.m_21187_().nextInt();
        }
    }

    public void setLastUpdateDay(int lastUpdateDay) {
        this.lastUpdateDay = lastUpdateDay;
    }

    public void onGiveMonsterItem(ServerPlayer player) {
        if (!this.gaveMonsterItem) {
            this.gaveMonsterItem = true;
            LevelCalc.levelSkill(player, this.data, EnumSkills.TAMING, 4.0f);
        }
    }

    public void onFoodEaten(ServerPlayer player) {
        if (!this.ateFood) {
            this.ateFood = true;
            LevelCalc.levelSkill(player, this.data, EnumSkills.EATING, 50.0f);
        }
    }

    public int getBathCounter() {
        return this.bathCounter;
    }

    public void increaseBathCounter() {
        ++this.bathCounter;
    }

    public int getDailyRandomSeed() {
        return this.dailyRandomSeed;
    }

    public Random getDailyRandom() {
        this.random.setSeed(this.getDailyRandomSeed());
        return this.random;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("LastUpdateDay", this.lastUpdateDay);
        compound.m_128379_("GaveMonsterItem", this.gaveMonsterItem);
        compound.m_128379_("AteFood", this.ateFood);
        compound.m_128405_("BathCounter", this.bathCounter);
        compound.m_128405_("DailyRandomSeed", this.dailyRandomSeed);
        return compound;
    }

    public void read(CompoundTag compound) {
        this.lastUpdateDay = compound.m_128451_("LastUpdateDay");
        this.gaveMonsterItem = compound.m_128471_("GaveMonsterItem");
        this.ateFood = compound.m_128471_("AteFood");
        this.bathCounter = compound.m_128451_("BathCounter");
        this.dailyRandomSeed = compound.m_128451_("DailyRandomSeed");
    }
}

