/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityStatsTracker {
    private final Object2IntMap<ResourceLocation> tamedMonsters = new Object2IntArrayMap();
    private final Object2IntMap<ResourceLocation> defeatedMonsters = new Object2IntArrayMap();
    private int tamedMonster;
    private int tamedBossMonster;

    public void tameEntity(BaseMonster monster) {
        ++this.tamedMonster;
        if (monster.m_6095_().m_204039_(RunecraftoryTags.BOSS_MONSTERS)) {
            ++this.tamedBossMonster;
        }
        this.tamedMonsters.computeInt((Object)Registry.f_122826_.m_7981_((Object)monster.m_6095_()), (id, o) -> {
            int n;
            if (o == null) {
                n = 1;
            } else {
                o = o + 1;
                n = o;
            }
            return n;
        });
    }

    public void killEntity(Entity entity) {
        this.defeatedMonsters.computeInt((Object)Registry.f_122826_.m_7981_((Object)entity.m_6095_()), (id, o) -> {
            int n;
            if (o == null) {
                n = 1;
            } else {
                o = o + 1;
                n = o;
            }
            return n;
        });
    }

    public int getTotalTameCount(boolean boss) {
        return boss ? this.tamedBossMonster : this.tamedMonster;
    }

    public int getTameCount(EntityType<?> type) {
        return this.tamedMonsters.getInt((Object)Registry.f_122826_.m_7981_(type));
    }

    public int getKillCount(EntityType<?> type) {
        return this.defeatedMonsters.getInt((Object)Registry.f_122826_.m_7981_(type));
    }

    public void reset() {
        this.tamedMonster = 0;
        this.tamedBossMonster = 0;
        this.tamedMonsters.clear();
        this.defeatedMonsters.clear();
    }

    public void read(CompoundTag tag) {
        this.tamedMonster = tag.m_128451_("TamedMonster");
        this.tamedBossMonster = tag.m_128451_("TamedBossMonster");
        CompoundTag tamed = tag.m_128469_("TamedMonstersTrack");
        tamed.m_128431_().forEach(key -> this.tamedMonsters.put((Object)new ResourceLocation(key), tamed.m_128451_(key)));
        CompoundTag killed = tag.m_128469_("KilledMonstersTrack");
        killed.m_128431_().forEach(key -> this.tamedMonsters.put((Object)new ResourceLocation(key), killed.m_128451_(key)));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("TamedMonster", this.tamedMonster);
        tag.m_128405_("TamedBossMonster", this.tamedBossMonster);
        CompoundTag tamed = new CompoundTag();
        this.tamedMonsters.forEach((id, val) -> tamed.m_128405_(id.toString(), val.intValue()));
        tag.m_128365_("TamedMonstersTrack", (Tag)tamed);
        CompoundTag killed = new CompoundTag();
        this.defeatedMonsters.forEach((id, val) -> killed.m_128405_(id.toString(), val.intValue()));
        tag.m_128365_("KilledMonstersTrack", (Tag)killed);
        return tag;
    }
}

