/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import java.util.function.IntUnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class LevelExpPair {
    private int level = 1;
    private float xp;
    private float required;

    public LevelExpPair() {
    }

    public LevelExpPair(FriendlyByteBuf buf) {
        this.fromPacket(buf);
    }

    public void setLevel(int level, IntUnaryOperator xpForNext) {
        this.level = level;
        this.required = xpForNext.applyAsInt(this.level);
    }

    public void setXp(float xp) {
        this.xp = xp;
    }

    public int getLevel() {
        return this.level;
    }

    public float getXp() {
        return this.xp;
    }

    public float getProgress() {
        if (this.required == -1.0f) {
            return 1.0f;
        }
        if (this.required <= 0.0f) {
            return 0.0f;
        }
        return Math.min(1.0f, this.xp / this.required);
    }

    public boolean addXP(float amount, int maxLevel, IntUnaryOperator xpForNext, Runnable onLevelUp) {
        if (amount < 0.0f) {
            int neededXP = xpForNext.applyAsInt(this.level - 1);
            this.required = neededXP;
            if (this.xp < -amount) {
                --this.level;
                float current = this.xp;
                this.xp = neededXP;
                return this.addXP(amount + current, maxLevel, xpForNext, onLevelUp);
            }
            this.xp -= amount;
            return false;
        }
        int neededXP = xpForNext.applyAsInt(this.level);
        this.required = neededXP;
        if (neededXP <= 0) {
            return false;
        }
        float xpToNextLevel = (float)neededXP - this.xp;
        if (amount >= xpToNextLevel) {
            float diff = amount - xpToNextLevel;
            ++this.level;
            this.xp = 0.0f;
            onLevelUp.run();
            this.addXP(diff, maxLevel, xpForNext, onLevelUp);
            return true;
        }
        if (this.level >= maxLevel) {
            amount = 0.0f;
            this.required = -1.0f;
        }
        this.xp += amount;
        return false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Level", this.level);
        tag.m_128350_("XP", this.xp);
        tag.m_128350_("Required", this.required);
        return tag;
    }

    public void read(Tag tag) {
        if (tag instanceof IntArrayTag) {
            IntArrayTag arrayTag = (IntArrayTag)tag;
            this.level = arrayTag.m_128648_()[0];
            this.xp = arrayTag.m_128648_()[1];
        } else if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.level = compoundTag.m_128451_("Level");
            this.xp = compoundTag.m_128457_("XP");
            this.required = compoundTag.m_128457_("Required");
        }
    }

    public void toPacket(FriendlyByteBuf buf) {
        buf.writeInt(this.level);
        buf.writeFloat(this.xp);
        buf.writeFloat(this.required);
    }

    public void from(LevelExpPair pair) {
        this.level = pair.getLevel();
        this.xp = pair.getXp();
        this.required = pair.required;
    }

    public void fromPacket(FriendlyByteBuf buf) {
        this.level = buf.readInt();
        this.xp = buf.readFloat();
        this.required = buf.readFloat();
    }

    public String toString() {
        return String.format("Level: %s, XP: %s", this.level, Float.valueOf(this.xp));
    }
}

