/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;

public class Party {
    private final Set<UUID> members = new HashSet<UUID>();

    public boolean addPartyMember(Entity entity) {
        if (this.isPartyFull()) {
            return false;
        }
        return this.members.add(entity.m_142081_());
    }

    public boolean removePartyMember(Entity entity) {
        return this.removePartyMember(entity.m_142081_());
    }

    public boolean removePartyMember(UUID uuid) {
        return this.members.remove(uuid);
    }

    public boolean isPartyMember(Entity entity) {
        return this.members.contains(entity.m_142081_());
    }

    public boolean isPartyFull() {
        return GeneralConfig.maxPartySize != 0 && this.members.size() >= GeneralConfig.maxPartySize;
    }

    public void load(CompoundTag tag) {
        ListTag members = tag.m_128437_("Party", 8);
        members.forEach(t -> this.members.add(UUID.fromString(t.m_7916_())));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag members = new ListTag();
        this.members.forEach(uuid -> members.add((Object)StringTag.m_129297_((String)uuid.toString())));
        tag.m_128365_("Party", (Tag)members);
        return tag;
    }
}

