/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.datapack.SkillProperties;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.DailyPlayerUpdater;
import io.github.flemmli97.runecraftory.common.attachment.player.EntitySelector;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.attachment.player.Party;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.RecipeKeeper;
import io.github.flemmli97.runecraftory.common.attachment.player.WalkingTracker;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShippingBin;
import io.github.flemmli97.runecraftory.common.inventory.InventorySpells;
import io.github.flemmli97.runecraftory.common.items.tools.ItemStatIncrease;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.network.S2CFoodPkt;
import io.github.flemmli97.runecraftory.common.network.S2CItemStatBoost;
import io.github.flemmli97.runecraftory.common.network.S2CLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMaxRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CMoney;
import io.github.flemmli97.runecraftory.common.network.S2CPlayerStats;
import io.github.flemmli97.runecraftory.common.network.S2CRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CSkillLevelPkt;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PlayerData {
    public boolean starting;
    public boolean unlockedRecipes;
    private int money = GeneralConfig.startingMoney;
    private float runePointsMax = GeneralConfig.startingRp;
    private int runePoints = (int)this.runePointsMax;
    private float str = GeneralConfig.startingStr;
    private float vit = GeneralConfig.startingVit;
    private float intel = GeneralConfig.startingIntel;
    private float strAdd;
    private float vitAdd;
    private float intAdd;
    private final LevelExpPair level = new LevelExpPair();
    private final EnumMap<EnumSkills, LevelExpPair> skillLevels = new EnumMap(EnumSkills.class);
    private final InventorySpells spells = new InventorySpells();
    private final DailyPlayerUpdater updater = new DailyPlayerUpdater(this);
    private int rpStillRegen;
    private final RecipeKeeper keeper = new RecipeKeeper();
    private final Map<Item, ShippedItemData> shippedItems = new HashMap<Item, ShippedItemData>();
    private final Map<NPCJob, NonNullList<ItemStack>> shopItems = new HashMap<NPCJob, NonNullList<ItemStack>>();
    private final InventoryShippingBin shipping = new InventoryShippingBin();
    private Item lastFoodBuff;
    private Map<Attribute, Double> foodBuffs = new HashMap<Attribute, Double>();
    private int foodDuration;
    private final PlayerWeaponHandler weaponHandler;
    private final WalkingTracker walkingTracker = new WalkingTracker();
    public final EntitySelector entitySelector = new EntitySelector();
    public final EntityStatsTracker entityStatsTracker = new EntityStatsTracker();
    public final Party party = new Party();
    private boolean touchedWater;
    private int craftingSeed;
    private int boughtBarns;
    private BlockPos blockBreakPosForMsg;
    private int breakTick;
    private int mobLevelIncrease;
    private NPCData.Gender gender;

    public PlayerData(Player player) {
        for (EnumSkills skill : EnumSkills.values()) {
            this.skillLevels.put(skill, new LevelExpPair());
        }
        this.weaponHandler = new PlayerWeaponHandler(player);
    }

    public void setMaxHealth(Player player, float amount, boolean asBaseHealth) {
        AttributeInstance health = player.m_21051_(Attributes.f_22276_);
        AttributeModifier modifier = health.m_22111_(LibConstants.MAX_HEALTH_MODIFIER);
        double val = (double)amount - (asBaseHealth ? health.m_22115_() : health.m_22135_());
        if (modifier != null && !asBaseHealth) {
            val += modifier.m_22218_();
        }
        health.m_22120_(LibConstants.MAX_HEALTH_MODIFIER);
        health.m_22125_(new AttributeModifier(LibConstants.MAX_HEALTH_MODIFIER, "rf.hpModifier", val, AttributeModifier.Operation.ADDITION));
    }

    private void setFoodHealthBonus(Player player, double amount) {
        AttributeInstance health = player.m_21051_(Attributes.f_22276_);
        health.m_22120_(LibConstants.FOOD_MODIFIER);
        health.m_22125_(new AttributeModifier(LibConstants.FOOD_MODIFIER, "rf.food.hpModifier", amount, AttributeModifier.Operation.ADDITION));
    }

    public int getRunePoints() {
        return this.runePoints;
    }

    public int getMaxRunePoints() {
        return (int)((double)this.runePointsMax + this.foodBuffs.getOrDefault(ModAttributes.RPINCREASE.get(), 0.0));
    }

    public float getMaxRunePointsRaw() {
        return this.runePointsMax;
    }

    public boolean decreaseRunePoints(Player player, int amount, boolean damage) {
        if (!GeneralConfig.useRp && !player.f_19853_.f_46443_) {
            return true;
        }
        if (!player.m_7500_()) {
            if (EntityUtils.isExhaust((LivingEntity)player)) {
                amount *= 2;
            }
            if (this.runePoints >= amount) {
                this.runePoints -= amount;
            } else if (damage) {
                int diff = amount - this.runePoints;
                this.runePoints = 0;
                if (!player.f_19853_.f_46443_) {
                    int invul = player.f_19802_;
                    player.f_19802_ = 10;
                    boolean res = player.m_6469_(CustomDamage.EXHAUST, Math.min(player.m_21233_() * 0.25f, (float)(diff * 2)));
                    player.f_19802_ = res ? 10 : invul;
                }
            } else {
                return false;
            }
            this.rpStillRegen = 200;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
            }
            return true;
        }
        return true;
    }

    public void refreshRunePoints(Player player, int amount) {
        this.runePoints = Mth.m_14045_((int)(this.runePoints + amount), (int)0, (int)this.getMaxRunePoints());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setRunePoints(Player player, int amount) {
        this.runePoints = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setMaxRunePoints(Player player, float amount) {
        this.runePointsMax = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CMaxRunePoints(this), serverPlayer);
        }
    }

    public int getMoney() {
        return this.money;
    }

    public boolean useMoney(Player player, int amount) {
        if (this.money >= amount) {
            this.money -= amount;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CMoney(this), serverPlayer);
            }
            return true;
        }
        return false;
    }

    public void setMoney(Player player, int amount) {
        this.money = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModCriteria.MONEY_TRIGGER.trigger(serverPlayer);
            Platform.INSTANCE.sendToClient(new S2CMoney(this), serverPlayer);
        }
    }

    public float getStr() {
        return this.str;
    }

    public void setStr(Player player, float amount) {
        this.str = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public float getVit() {
        return this.vit;
    }

    public void setVit(Player player, float amount) {
        this.vit = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public float getIntel() {
        return this.intel;
    }

    public void setIntel(Player player, float amount) {
        this.intel = amount;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public LevelExpPair getPlayerLevel() {
        return this.level;
    }

    public void setPlayerLevel(Player player, int level, float xpAmount, boolean recalc) {
        this.level.setLevel(Mth.m_14045_((int)level, (int)1, (int)GeneralConfig.maxLevel), LevelCalc::xpAmountForLevelUp);
        this.level.setXp(Mth.m_14036_((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForLevelUp(level)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (recalc) {
                this.recalculateStats(serverPlayer, true);
            } else {
                Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), serverPlayer);
            }
        }
    }

    public void addXp(Player player, float amount) {
        if (this.level.getLevel() >= GeneralConfig.maxLevel) {
            return;
        }
        boolean levelUp = this.level.addXP(amount, GeneralConfig.maxLevel, LevelCalc::xpAmountForLevelUp, () -> this.onLevelUp(player));
        if (levelUp) {
            player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (levelUp) {
                ModCriteria.LEVEL_TRIGGER.trigger(serverPlayer);
            }
            Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), serverPlayer);
        }
    }

    private void onLevelUp(Player player) {
        float health = player.m_21233_();
        this.updateHealth(player);
        player.m_5634_(player.m_21233_() - health);
        this.runePointsMax += GeneralConfig.rpPerLevel;
        this.runePoints = Math.min(this.runePoints + (int)GeneralConfig.rpPerLevel, this.runePoints);
        this.str += GeneralConfig.strPerLevel;
        this.vit += GeneralConfig.vitPerLevel;
        this.intel += GeneralConfig.intPerLevel;
    }

    public void recalculateStats(ServerPlayer player, boolean regen) {
        int lvl = this.level.getLevel() - 1;
        this.updateHealth((Player)player);
        this.runePointsMax = GeneralConfig.rpPerLevel * (float)lvl + (float)GeneralConfig.startingRp + (float)((int)this.skillValLevelFunc((skillLvl, prop) -> Float.valueOf((float)Math.min(100, skillLvl) * prop.rpIncrease())));
        if (regen) {
            player.m_21153_(player.m_21233_());
            this.runePoints = (int)this.runePointsMax;
        }
        this.str = GeneralConfig.strPerLevel * (float)lvl + (float)GeneralConfig.startingStr + (float)this.skillVal(SkillProperties::strIncrease);
        this.intel = GeneralConfig.intPerLevel * (float)lvl + (float)GeneralConfig.startingIntel + (float)this.skillVal(SkillProperties::intelIncrease);
        this.vit = GeneralConfig.vitPerLevel * (float)lvl + (float)GeneralConfig.startingVit + (float)this.skillVal(SkillProperties::vitIncrease);
        Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), player);
    }

    private double skillVal(Function<SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> (double)(((LevelExpPair)e.getValue()).getLevel() - 1) * ((Number)func.apply(DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((EnumSkills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    private double skillValLevelFunc(BiFunction<Integer, SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> ((Number)func.apply(((LevelExpPair)e.getValue()).getLevel() - 1, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((EnumSkills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    public LevelExpPair getSkillLevel(EnumSkills skill) {
        return this.skillLevels.get((Object)skill);
    }

    public void setSkillLevel(EnumSkills skill, Player player, int level, float xpAmount, boolean recalc) {
        this.skillLevels.get((Object)skill).setLevel(player.f_19853_.f_46443_ ? level : Mth.m_14045_((int)level, (int)1, (int)DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()), l -> LevelCalc.xpAmountForSkillLevelUp(skill, l));
        this.skillLevels.get((Object)skill).setXp(player.f_19853_.f_46443_ ? xpAmount : Mth.m_14036_((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForSkillLevelUp(skill, level)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (recalc) {
                this.recalculateStats(serverPlayer, true);
                player.m_21153_(player.m_21233_());
            }
            Platform.INSTANCE.sendToClient(new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    public void increaseSkill(EnumSkills skill, Player player, float amount) {
        if (this.skillLevels.get((Object)skill).getLevel() >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return;
        }
        boolean levelUp = this.skillLevels.get((Object)skill).addXP(amount, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel(), lvl -> LevelCalc.xpAmountForSkillLevelUp(skill, lvl), () -> this.onSkillLevelUp(skill, player));
        if (levelUp) {
            player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (levelUp) {
                ModCriteria.SKILL_LEVEL_TRIGGER.trigger(serverPlayer, skill);
            }
            Platform.INSTANCE.sendToClient(new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    private void onSkillLevelUp(EnumSkills skill, Player player) {
        SkillProperties prop = DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill);
        int level = this.skillLevels.get((Object)skill).getLevel();
        float health = player.m_21233_();
        this.updateHealth(player);
        player.m_5634_(player.m_21233_() - health);
        if (level <= 100) {
            this.runePointsMax += prop.rpIncrease();
            this.runePoints = (int)((float)this.runePoints + prop.rpIncrease());
        }
        this.str += prop.strIncrease();
        this.vit += prop.vitIncrease();
        this.intel += prop.intelIncrease();
    }

    private void updateHealth(Player player) {
        this.setMaxHealth(player, (float)GeneralConfig.startingHealth + GeneralConfig.hpPerLevel * LevelCalc.getMultiplierInterval(this.level.getLevel(), 30, 30.0f, 0.5f) + (float)this.skillValLevelFunc((skillLvl, prop) -> {
            int skillHealthMultiplier = 1 + skillLvl / 25;
            return Float.valueOf((float)skillHealthMultiplier * prop.healthIncrease() * (float)skillLvl.intValue());
        }), true);
    }

    public void increaseStatBonus(Player player, ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.strAdd += 1.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case INT: {
                this.intAdd += 1.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case VIT: {
                this.vitAdd += 1.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case HP: {
                AttributeInstance health = player.m_21051_(Attributes.f_22276_);
                AttributeModifier modifier = health.m_22111_(LibConstants.MAX_HEALTH_ITEM_INCREASE);
                double val = modifier == null ? 0.0 : modifier.m_22218_();
                health.m_22120_(LibConstants.MAX_HEALTH_ITEM_INCREASE);
                health.m_22125_(new AttributeModifier(LibConstants.MAX_HEALTH_ITEM_INCREASE, "rf.item.hpModifier", val + 10.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void resetAllStatBoost(Player player, ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.strAdd = 0.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case INT: {
                this.intAdd = 0.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case VIT: {
                this.vitAdd = 0.0f;
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case HP: {
                AttributeInstance health = player.m_21051_(Attributes.f_22276_);
                health.m_22120_(LibConstants.MAX_HEALTH_ITEM_INCREASE);
            }
        }
    }

    public double getAttributeValue(Player player, Attribute att) {
        double val = 0.0;
        float vit = this.getVit() + this.vitAdd;
        if (att == Attributes.f_22281_) {
            val += (double)(this.getStr() + this.strAdd);
            val += (double)EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
        }
        if (att == ModAttributes.MAGIC.get()) {
            val += (double)(this.getIntel() + this.intAdd);
        }
        if (att == ModAttributes.DEFENCE.get()) {
            val += (double)vit * 0.5;
        }
        if (att == ModAttributes.MAGIC_DEFENCE.get()) {
            val += (double)vit * 0.5;
        }
        val += this.foodBuffs.getOrDefault(att, 0.0).doubleValue();
        AttributeMap atts = player.m_21204_();
        return val += atts.m_22171_(att) ? atts.m_22181_(att) : 0.0;
    }

    public InventorySpells getInv() {
        return this.spells;
    }

    public InventoryShippingBin getShippingInv() {
        return this.shipping;
    }

    public void refreshShop(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (NPCJob profession : ModNPCJobs.allJobs()) {
                Collection<ShopItemProperties> datapack = DataPackHandler.INSTANCE.shopItemsManager().get(profession);
                ArrayList shopItems = new ArrayList();
                datapack.forEach(shopProps -> {
                    boolean canAdd;
                    block7: {
                        boolean bl;
                        block6: {
                            if (!shopProps.predicate().m_36611_(serverPlayer, (Entity)serverPlayer)) break block6;
                            switch (shopProps.unlockType()) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case DEFAULT: {
                                    break block6;
                                }
                                case ALWAYS: {
                                    break;
                                }
                                case NEEDS_SHIPPING: {
                                    if (!this.shippedItems.containsKey(shopProps.stack().m_41720_())) break block6;
                                }
                            }
                            bl = true;
                            break block7;
                        }
                        bl = canAdd = false;
                    }
                    if (canAdd) {
                        shopItems.add(shopProps.stack().m_41777_());
                    }
                });
                NonNullList shop = NonNullList.m_122779_();
                if (!shopItems.isEmpty()) {
                    for (float chance = 1.5f + (float)shopItems.size() * 0.002f; player.f_19853_.f_46441_.nextFloat() < chance; chance -= 0.1f) {
                        ItemStack stack = (ItemStack)shopItems.remove(player.f_19853_.f_46441_.nextInt(shopItems.size()));
                        shop.add((Object)stack);
                        if (shopItems.isEmpty() || profession == ModNPCJobs.RANDOM.getSecond() && shop.size() >= 30) break;
                    }
                }
                DataPackHandler.INSTANCE.shopItemsManager().getDefaultItems(profession).forEach(props -> shop.add((Object)props.stack()));
                this.shopItems.put(profession, (NonNullList<ItemStack>)shop);
            }
        }
    }

    public NonNullList<ItemStack> getShop(NPCJob shop) {
        NonNullList list = NonNullList.m_122779_();
        list.addAll((Collection)this.shopItems.getOrDefault(shop, (NonNullList<ItemStack>)NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_)));
        return list;
    }

    public void addShippingItem(ItemStack stack) {
        int level = ItemNBT.itemLevel(stack);
        this.shippedItems.compute(stack.m_41720_(), (k, v) -> v == null ? new ShippedItemData(stack.m_41613_(), level) : new ShippedItemData(v.amount + stack.m_41613_(), Math.max(v.maxLevel, level)));
    }

    public ShippedItemData shippedItemData(ItemStack stack) {
        return this.shippedItems.get(stack.m_41720_());
    }

    public int getShippedTypesAmount() {
        return this.shippedItems.size();
    }

    public RecipeKeeper getRecipeKeeper() {
        return this.keeper;
    }

    public Item lastEatenFood() {
        return this.lastFoodBuff;
    }

    public void applyFoodEffect(Player player, ItemStack stack) {
        FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_());
        if (food == null) {
            return;
        }
        Pair<Map<Attribute, Double>, Map<Attribute, Double>> foodStats = ItemNBT.foodStats(stack);
        Map gain = (Map)foodStats.getFirst();
        ((Map)foodStats.getSecond()).forEach((att, d) -> {
            float percent = (float)(d * (double)0.01f);
            double mult = 0.0;
            if (att == Attributes.f_22276_) {
                mult += (double)(player.m_21233_() * percent);
            } else if (att == ModAttributes.RPINCREASE.get()) {
                mult += (double)(this.runePointsMax * percent);
            } else if (att == Attributes.f_22281_) {
                mult += (double)(this.str * percent);
            } else if (att == ModAttributes.DEFENCE.get()) {
                mult += (double)this.vit * 0.5 * (double)percent;
            } else if (att == ModAttributes.MAGIC.get()) {
                mult += (double)(this.intel * percent);
            } else if (att == ModAttributes.DEFENCE.get()) {
                mult += (double)this.vit * 0.5 * (double)percent;
            }
            gain.put(att, mult += gain.getOrDefault(att, 0.0).doubleValue());
        });
        if (!gain.isEmpty()) {
            this.removeFoodEffect(player);
            this.foodBuffs = gain;
            if (this.foodBuffs.containsKey(Attributes.f_22276_)) {
                this.setFoodHealthBonus(player, this.foodBuffs.get(Attributes.f_22276_));
            }
            this.foodDuration = food.duration();
            this.lastFoodBuff = stack.m_41720_();
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CFoodPkt(stack), serverPlayer);
        }
    }

    public void removeFoodEffect(Player player) {
        this.foodBuffs = Collections.emptyMap();
        this.foodDuration = -1;
        this.lastFoodBuff = null;
        this.setFoodHealthBonus(player, 0.0);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendToClient(new S2CFoodPkt(null), serverPlayer);
        }
    }

    public Map<Attribute, Double> foodEffects() {
        return this.foodBuffs;
    }

    public int foodBuffDuration() {
        return this.foodDuration;
    }

    public CompoundTag foodBuffNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.lastFoodBuff != null) {
            nbt.m_128359_("LastFood", Registry.f_122827_.m_7981_((Object)this.lastFoodBuff).toString());
        }
        CompoundTag compound3 = new CompoundTag();
        for (Map.Entry<Attribute, Double> entry : this.foodBuffs.entrySet()) {
            compound3.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
        }
        nbt.m_128365_("FoodBuffs", (Tag)compound3);
        nbt.m_128405_("FoodBuffDuration", this.foodDuration);
        return nbt;
    }

    public void readFoodBuffFromNBT(CompoundTag nbt) {
        this.lastFoodBuff = nbt.m_128441_("LastFood") ? (Item)Registry.f_122827_.m_7745_(new ResourceLocation(nbt.m_128461_("LastFood"))) : null;
        this.foodBuffs.clear();
        CompoundTag tag = nbt.m_128469_("FoodBuffs");
        for (String s : tag.m_128431_()) {
            this.foodBuffs.put((Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(s)), tag.m_128459_(s));
        }
        this.foodDuration = nbt.m_128451_("FoodBuffDuration");
    }

    public PlayerWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    public void tick(Player player) {
        this.weaponHandler.tick();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.updater.tick(serverPlayer);
            if (serverPlayer.f_19797_ % 10 == 0 && this.walkingTracker.tickWalkingTracker(serverPlayer)) {
                this.rpStillRegen = 200;
            }
            if (--this.rpStillRegen < 0 && serverPlayer.f_19797_ % 20 == 0) {
                this.refreshRunePoints(player, 1);
            }
            if (--this.breakTick <= 0) {
                this.blockBreakPosForMsg = null;
            }
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            if (main.m_150930_((Item)ModItems.MOB_STAFF.get()) || off.m_150930_((Item)ModItems.MOB_STAFF.get())) {
                if (this.entitySelector.poi != null) {
                    serverPlayer.m_183503_().m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123744_, true, (double)this.entitySelector.poi.m_123341_() + 0.5, (double)this.entitySelector.poi.m_123342_() + 1.5, (double)this.entitySelector.poi.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    serverPlayer.m_183503_().m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123744_, true, (double)this.entitySelector.poi.m_123341_() + 0.5, (double)this.entitySelector.poi.m_123342_() + 1.5, (double)this.entitySelector.poi.m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, 0.01);
                }
            } else {
                this.entitySelector.reset();
            }
            if (serverPlayer.m_21023_((MobEffect)ModEffects.BATH.get())) {
                if (!this.touchedWater && serverPlayer.m_20069_()) {
                    this.touchedWater = true;
                } else if (this.touchedWater && !serverPlayer.m_20069_()) {
                    serverPlayer.m_21195_((MobEffect)ModEffects.BATH.get());
                    this.touchedWater = false;
                }
            }
        }
        this.getInv().update(player);
        this.foodDuration = Math.max(--this.foodDuration, -1);
        if (this.foodDuration == 0) {
            this.removeFoodEffect(player);
        }
    }

    public DailyPlayerUpdater getDailyUpdater() {
        return this.updater;
    }

    public int getCraftingSeed(Player player) {
        if (this.craftingSeed == 0) {
            this.craftingSeed = player.m_21187_().nextInt();
        }
        return this.craftingSeed;
    }

    public void onCrafted(Player player) {
        this.craftingSeed = player.m_21187_().nextInt();
    }

    public int getBoughtBarns() {
        return this.boughtBarns;
    }

    public void onBuyBarn() {
        ++this.boughtBarns;
    }

    public boolean onBarnFailMine(BlockPos pos) {
        boolean start = !pos.equals((Object)this.blockBreakPosForMsg);
        this.blockBreakPosForMsg = pos;
        this.breakTick = 20;
        return start;
    }

    public void increaseMobFrom(ServerPlayer player, BaseMonster monster) {
        this.entityStatsTracker.killEntity((Entity)monster);
        this.increaseMobLevel(monster.getProp().levelIncreaseFromKill(this.entityStatsTracker.getKillCount(monster.m_6095_()), player));
    }

    public void increaseMobLevel(int increase) {
        this.mobLevelIncrease += increase;
    }

    public int getMobLevelIncrease() {
        return this.mobLevelIncrease;
    }

    public NPCData.Gender getGender() {
        return this.gender;
    }

    public void readFromNBT(CompoundTag nbt, Player player) {
        this.starting = nbt.m_128471_("Starting");
        this.runePointsMax = nbt.m_128457_("MaxRunePoints");
        this.runePoints = nbt.m_128451_("RunePoints");
        this.money = nbt.m_128451_("Money");
        this.str = nbt.m_128457_("Strength");
        this.vit = nbt.m_128457_("Vitality");
        this.intel = nbt.m_128457_("Intelligence");
        this.level.read(nbt.m_128423_("Level"));
        this.strAdd = nbt.m_128457_("StrengthBonus");
        this.vitAdd = nbt.m_128457_("VitalityBonus");
        this.intAdd = nbt.m_128457_("IntelligenceBonus");
        CompoundTag skillCompound = nbt.m_128469_("Skills");
        for (EnumSkills skill : EnumSkills.values()) {
            this.skillLevels.get((Object)skill).read(skillCompound.m_128423_(skill.toString()));
        }
        this.spells.load(nbt.m_128469_("Inventory"));
        this.shipping.load(nbt.m_128469_("Shipping"));
        CompoundTag shipped = nbt.m_128469_("ShippedItems");
        shipped.m_128431_().forEach(key -> {
            CompoundTag d = shipped.m_128469_(key);
            this.shippedItems.put((Item)Registry.f_122827_.m_7745_(new ResourceLocation(key)), new ShippedItemData(d.m_128451_("Amount"), d.m_128451_("Level")));
        });
        CompoundTag shops = nbt.m_128469_("ShopItems");
        shops.m_128431_().forEach(key -> {
            NonNullList items = NonNullList.m_122779_();
            shops.m_128437_(key, 10).forEach(comp -> items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)comp))));
            this.shopItems.put(ModNPCJobs.getFromID(new ResourceLocation(key)), (NonNullList<ItemStack>)items);
        });
        this.keeper.read(nbt.m_128469_("Recipes"));
        this.updater.read(nbt.m_128469_("DailyUpdater"));
        this.readFoodBuffFromNBT(nbt.m_128469_("FoodData"));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8906_ != null) {
                this.recalculateStats(serverPlayer, false);
            }
        }
        if (nbt.m_128441_("RestoreHP") && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            float f = nbt.m_128457_("RestoreHP");
            serverPlayer.m_20194_().m_6937_((Runnable)new TickTask(1, () -> player.m_21153_(f)));
        }
        this.walkingTracker.read(nbt.m_128469_("WalkingTracker"));
        this.party.load(nbt.m_128469_("PartyTag"));
        this.craftingSeed = nbt.m_128451_("CraftingSeed");
        this.boughtBarns = nbt.m_128451_("BoughtBarns");
        this.mobLevelIncrease = nbt.m_128451_("MobLevelIncrease");
    }

    public CompoundTag writeToNBTPlain(CompoundTag nbt) {
        return this.writeToNBT(nbt, null, false);
    }

    public CompoundTag writeToNBT(CompoundTag nbt, Player player, boolean wasDead) {
        nbt.m_128379_("Starting", this.starting);
        nbt.m_128350_("MaxRunePoints", this.runePointsMax);
        if (player == null) {
            nbt.m_128405_("RunePoints", this.runePoints);
        } else if (wasDead) {
            nbt.m_128350_("RestoreHP", player.m_21233_() * GeneralConfig.deathHpPercent);
            nbt.m_128405_("RunePoints", (int)(this.runePointsMax * GeneralConfig.deathRpPercent));
        } else {
            nbt.m_128350_("RestoreHP", player.m_21223_());
            nbt.m_128405_("RunePoints", this.runePoints);
        }
        nbt.m_128405_("Money", this.money);
        nbt.m_128350_("Strength", this.str);
        nbt.m_128350_("Vitality", this.vit);
        nbt.m_128350_("Intelligence", this.intel);
        nbt.m_128365_("Level", (Tag)this.level.save());
        nbt.m_128350_("StrengthBonus", this.strAdd);
        nbt.m_128350_("VitalityBonus", this.vitAdd);
        nbt.m_128350_("IntelligenceBonus", this.intAdd);
        CompoundTag skillCompound = new CompoundTag();
        for (EnumSkills skill : EnumSkills.values()) {
            skillCompound.m_128365_(skill.toString(), (Tag)this.skillLevels.get((Object)skill).save());
        }
        nbt.m_128365_("Skills", (Tag)skillCompound);
        nbt.m_128365_("Inventory", (Tag)this.spells.save());
        nbt.m_128365_("Shipping", (Tag)this.shipping.save());
        CompoundTag ship = new CompoundTag();
        this.shippedItems.forEach((key, value) -> {
            CompoundTag d = new CompoundTag();
            d.m_128405_("Amount", value.amount);
            d.m_128405_("Level", value.maxLevel);
            ship.m_128365_(key.toString(), (Tag)d);
        });
        nbt.m_128365_("ShippedItems", (Tag)ship);
        CompoundTag shop = new CompoundTag();
        for (Map.Entry<NPCJob, NonNullList<ItemStack>> entry : this.shopItems.entrySet()) {
            ListTag l = new ListTag();
            for (ItemStack stack : entry.getValue()) {
                l.add((Object)stack.m_41739_(new CompoundTag()));
            }
            shop.m_128365_(ModNPCJobs.getIDFrom(entry.getKey()).toString(), (Tag)l);
        }
        nbt.m_128365_("ShopItems", (Tag)shop);
        nbt.m_128365_("Recipes", (Tag)this.keeper.save());
        nbt.m_128365_("DailyUpdater", (Tag)this.updater.save());
        nbt.m_128365_("FoodData", (Tag)this.foodBuffNBT());
        nbt.m_128365_("WalkingTracker", (Tag)this.walkingTracker.save());
        nbt.m_128365_("TamedEntityTracker", (Tag)this.entityStatsTracker.save());
        nbt.m_128365_("PartyTag", (Tag)this.party.save());
        nbt.m_128405_("CraftingSeed", this.craftingSeed);
        nbt.m_128405_("BoughtBarns", this.boughtBarns);
        nbt.m_128405_("MobLevelIncrease", this.mobLevelIncrease);
        return nbt;
    }

    public void resetAll(ServerPlayer player) {
        PlayerData newData = new PlayerData((Player)player);
        newData.spells.load(this.spells.save());
        newData.shipping.load(this.shipping.save());
        this.readFromNBT(newData.writeToNBTPlain(new CompoundTag()), null);
        this.recalculateStats(player, false);
        this.refreshShop((Player)player);
        this.starting = false;
        this.entityStatsTracker.reset();
        this.mobLevelIncrease = 0;
    }

    public record ShippedItemData(int amount, int maxLevel) {
    }
}

