/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.network.S2CWeaponUse;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PlayerWeaponHandler
implements AttackActionHandler {
    private static final int COOLDOWN = 6;
    private final Player entity;
    private AttackAction currentAction = (AttackAction)((Object)ModAttackActions.NONE.get());
    private int comboCount;
    private boolean scheduledAction;
    private AnimatedAction currentAnimation;
    private AnimatedAction lastAnimation;
    private int timeSinceLastChange;
    private final Set<LivingEntity> hitEntityTracker = new HashSet<LivingEntity>();
    private final Map<DataKey<?>, Object> dataMap = new HashMap();

    public PlayerWeaponHandler(Player entity) {
        this.entity = entity;
    }

    public boolean doWeaponAttack(AttackAction action, ItemStack stack) {
        return this.doWeaponAttack(action, stack, null);
    }

    @Override
    public boolean doWeaponAttack(AttackAction action, ItemStack stack, @Nullable Spell spell) {
        AttackAction.OverrideType overrideType = this.checkOverride(action, true);
        if (this.entity.f_19853_.f_46443_ || overrideType != AttackAction.OverrideType.NONE) {
            if (overrideType == AttackAction.OverrideType.SCHEDULE) {
                this.scheduledAction = true;
                return true;
            }
            action.onSetup((LivingEntity)this.entity, this);
            this.setAnimationBasedOnState(action, -1, true);
            this.store(DataKey.USED_WEAPON, stack);
            this.store(DataKey.USED_SPELL, spell);
            return true;
        }
        return false;
    }

    public boolean canExecuteAction(AttackAction action) {
        return this.canExecuteAction(action, true);
    }

    public boolean canExecuteAction(AttackAction action, boolean allowNone) {
        return this.checkOverride(action, allowNone) != AttackAction.OverrideType.NONE;
    }

    private AttackAction.OverrideType checkOverride(AttackAction action, boolean allowNone) {
        if (allowNone && (this.currentAction == ModAttackActions.NONE.get() || this.currentAnimation == null)) {
            return this.timeSinceLastChange < 6 ? AttackAction.OverrideType.NONE : AttackAction.OverrideType.REPLACE;
        }
        if (this.entity.m_20202_() != null && !action.usableOnMounts(this.comboCount + 1)) {
            return AttackAction.OverrideType.NONE;
        }
        if (this.currentAction == action && action.combos() != null) {
            ComboContainer.ComboHandler combo = action.combos().get(this.comboCount - 1);
            return combo != null && combo.canExecute().test(this) ? AttackAction.OverrideType.SCHEDULE : AttackAction.OverrideType.NONE;
        }
        return AttackAction.OverrideType.NONE;
    }

    private void setAnimationBasedOnState(AttackAction action, int comboIdx, boolean packet) {
        AttackAction change = this.currentAction.onChange((LivingEntity)this.entity, this);
        if (change != null) {
            action = change;
        }
        if (comboIdx != -1) {
            this.comboCount = comboIdx;
        }
        if (action == ModAttackActions.NONE.get()) {
            this.resetStates();
        }
        this.lastAnimation = this.currentAnimation;
        this.timeSinceLastChange = 0;
        this.currentAction = action;
        this.scheduledAction = false;
        this.currentAnimation = action.getAnimation((LivingEntity)this.entity, this.getComboCount());
        if (this.currentAction != ModAttackActions.NONE.get()) {
            ++this.comboCount;
        }
        this.entity.f_20883_ = this.entity.f_20885_;
        this.resetHitEntityTracker();
        this.currentAction.onStart((LivingEntity)this.entity, this);
        if (!this.entity.f_19853_.f_46443_ && packet) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CWeaponUse(this.currentAction, this.get(DataKey.USED_WEAPON), this.comboCount - 1, (LivingEntity)this.entity), (Entity)this.entity);
        }
    }

    public void clientSideUpdate(AttackAction action, ItemStack stack, int count) {
        if (!this.entity.f_19853_.f_46443_) {
            return;
        }
        this.comboCount = count;
        this.setAnimationBasedOnState(action, -1, false);
        this.store(DataKey.USED_WEAPON, stack);
    }

    private void resetStates() {
        this.comboCount = 0;
        this.hitEntityTracker.clear();
        Set.copyOf(this.dataMap.keySet()).forEach(this::clear);
    }

    @Override
    public void tick() {
        if (this.currentAnimation != null) {
            ComboContainer.ComboHandler handler;
            ComboContainer.ComboHandler comboHandler = handler = this.currentAction.combos() != null ? this.currentAction.combos().get(this.comboCount - 1) : null;
            if (this.scheduledAction && handler != null && handler.canAdvance().test(this)) {
                this.setAnimationBasedOnState(this.currentAction, handler.advanceTo().get(this), true);
                return;
            }
            if (this.currentAnimation.tick(1 + (int)(this.currentAnimation.getSpeed() * (float)(handler != null ? handler.resetTime() : 0)))) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1, false);
            } else {
                ItemStack weapon = this.get(DataKey.USED_WEAPON);
                Player player = this.entity;
                if (player instanceof ServerPlayer) {
                    boolean changedItem;
                    ServerPlayer player2 = (ServerPlayer)player;
                    PlayerData data = Platform.INSTANCE.getPlayerData((Player)player2).orElse(null);
                    boolean bl = changedItem = this.entity.m_21205_() != weapon;
                    if (changedItem && weapon.m_41720_() instanceof ItemSpell && data != null) {
                        for (int i = 0; i < data.getInv().m_6643_(); ++i) {
                            if (data.getInv().m_8020_(i) != weapon) continue;
                            changedItem = false;
                            break;
                        }
                    }
                    if (changedItem) {
                        this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1, true);
                    }
                }
                this.currentAction.run((LivingEntity)this.entity, weapon, this, this.currentAnimation);
            }
        }
        ++this.timeSinceLastChange;
        if (this.lastAnimation != null && this.timeSinceLastChange > this.lastAnimation.getEndTransitionTime()) {
            this.lastAnimation = null;
        }
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isScheduledAction() {
        return this.scheduledAction;
    }

    @Override
    public <T> void store(DataKey<T> key, T value) {
        this.dataMap.put(key, value);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return (T)this.dataMap.getOrDefault(key, key.defaultValue());
    }

    @Override
    public <T> void clearWith(DataKey<T> key, @Nullable Consumer<T> apply) {
        if (apply == null) {
            this.dataMap.remove(key);
        } else {
            apply.accept(this.dataMap.remove(key));
        }
    }

    @Override
    public AttackAction getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public float getCurrentTransitionProgress(float partialTicks) {
        if (this.currentAnimation == null) {
            return 1.0f;
        }
        return this.currentAnimation.getStartTransitionProgress(partialTicks);
    }

    @Override
    public float getLastTransitionProgress(float partialTicks) {
        if (this.lastAnimation == null) {
            return 0.0f;
        }
        return 1.0f - Mth.m_14036_((float)(((float)(this.timeSinceLastChange - 1) + partialTicks) / (float)this.lastAnimation.getEndTransitionTime()), (float)0.0f, (float)1.0f);
    }

    @Override
    public AnimatedAction getAnimation() {
        return this.currentAnimation;
    }

    @Override
    public AnimatedAction getLastAnimation() {
        return this.lastAnimation;
    }

    @Override
    public void setComboCount(int count) {
        this.comboCount = count;
    }

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    public float movementReduction() {
        return this.currentAction.movementReduction(this.currentAnimation);
    }

    public boolean isItemSwapBlocked() {
        return this.currentAction.disableItemSwitch();
    }

    @Override
    public Set<LivingEntity> getHitEntityTracker() {
        return this.hitEntityTracker;
    }
}

