/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;

public class WalkingTracker {
    private static final Map<ResourceLocation, Float> RELEVANT_STATS = WalkingTracker.relevantStatMap();
    private final Map<ResourceLocation, Integer> lastCheck = new HashMap<ResourceLocation, Integer>();

    private static Map<ResourceLocation, Float> relevantStatMap() {
        HashMap<ResourceLocation, Float> map = new HashMap<ResourceLocation, Float>();
        map.put(Stats.f_12994_, Float.valueOf(0.8f));
        map.put(Stats.f_12995_, Float.valueOf(1.25f));
        map.put(Stats.f_12996_, Float.valueOf(0.3f));
        map.put(Stats.f_12997_, Float.valueOf(0.9f));
        map.put(Stats.f_13001_, Float.valueOf(1.0f));
        map.put(Stats.f_12924_, Float.valueOf(0.65f));
        map.put(Stats.f_13000_, Float.valueOf(0.15f));
        map.put(Stats.f_12923_, Float.valueOf(0.07f));
        return map;
    }

    public boolean tickWalkingTracker(ServerPlayer player) {
        ServerStatsCounter counter = player.m_8951_();
        float mult = 0.0f;
        for (Map.Entry<ResourceLocation, Float> e : RELEVANT_STATS.entrySet()) {
            mult += this.calcMultiplier(e.getKey(), counter, e.getValue().floatValue());
        }
        if (mult != 0.0f) {
            float finalMult = mult * 0.3f;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.WALKING, finalMult));
        }
        return mult != 0.0f;
    }

    private float calcMultiplier(ResourceLocation res, ServerStatsCounter counter, float weight) {
        int last = this.lastCheck.getOrDefault(res, 0);
        int current = counter.m_13015_(Stats.f_12988_.m_12902_((Object)res));
        if (Math.abs(current - last) > 0) {
            float m = (float)Math.min(current - last, 1000) * weight * 0.005f;
            this.lastCheck.put(res, current);
            return m;
        }
        return 0.0f;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        this.lastCheck.forEach((res, v) -> compound.m_128405_(res.toString(), v.intValue()));
        return compound;
    }

    public void read(CompoundTag compound) {
        compound.m_128431_().forEach(key -> this.lastCheck.put(new ResourceLocation(key), compound.m_128451_(key)));
    }
}

