/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DashSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end"), 0).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.DASH_SLASH.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.MOVE_DIRECTION, null);
            entity.m_20256_(entity.m_20184_().m_82542_(0.95, 1.0, 0.95));
            if (anim.isAt("attack")) {
                if (!entity.f_19853_.f_46443_) {
                    OrientedBoundingBox obb = new OrientedBoundingBox(new AABB((double)(-entity.m_20205_()), 0.0, 0.0, (double)entity.m_20205_(), 1.0, (double)(entity.m_20205_() + 1.0f)).m_82400_(0.3), entity.m_146908_(), 0.0f, entity.m_20182_());
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(obb)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 1.0f)).executeAttack();
                }
                entity.m_5496_(SoundEvents.f_12316_, 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        } else {
            Vec3 dir;
            handler.store(DataKey.FIXED_LOOK, true);
            if (anim.isAt("move_start")) {
                dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.5).m_82520_(0.0, 0.3, 0.0));
            }
            if (anim.isPast("attack_start")) {
                if (anim.isAt("attack_start")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.5));
                }
                handler.applyMoveDirection();
                if (anim.isAt("sound")) {
                    entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
                }
                if (!entity.f_19853_.f_46443_ && !anim.isPast("attack_end")) {
                    double range = CombatUtils.getRange(entity, -1.0);
                    handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82377_(range * 0.5, 0.0, 0.0).m_82363_(0.0, 0.0, range))).withBonusAttributes(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
            }
            if (anim.isAt("attack_end")) {
                handler.store(DataKey.MOVE_DIRECTION, null);
            }
            handler.applyMoveDirection();
        }
    }

    @Override
    public void onEnd(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() != 1) {
            return;
        }
        Vec3 mot = entity.m_20184_();
        double lenHor = mot.f_82479_ * mot.f_82479_ + mot.f_82481_ * mot.f_82481_;
        entity.m_20256_(mot.m_82542_(lenHor > 0.5 ? 0.5 : 1.0, 1.0, lenHor > 0.5 ? 0.5 : 1.0));
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 1;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

