/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FireballUseAttack
extends AttackAction {
    private final ComboContainer combo;

    public FireballUseAttack(boolean big) {
        ComboContainer.Builder builder = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("attack"), 4);
        if (!big) {
            builder.addCombo(handler -> handler.getAnimation().isPast("attack"), 4);
        }
        this.combo = builder.build();
    }

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.STAFF_USE.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        Level level = entity.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (anim.isAt("attack")) {
                Spell spell;
                entity.m_6674_(InteractionHand.MAIN_HAND);
                if (handler.get(DataKey.USED_SPELL) != null && (spell = handler.get(DataKey.USED_SPELL)).use(serverLevel, entity, stack) && entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (stack.m_41720_() instanceof ItemSpell) {
                        player.m_36335_().m_41524_(stack.m_41720_(), spell.coolDown());
                    }
                    spell.levelSkill(player);
                }
            }
        }
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

