/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GigaSwingAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.GIGA_SWING.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        CombatUtils.EntityAttack attack;
        if (anim.isAt("attack_start")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_() - 50.0f));
            Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0)).m_82490_(-1.0);
            handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(2.0));
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        if (!entity.f_19853_.f_46443_ && (attack = GigaSwingAttack.spinAttack(entity, anim, anim.getMarker("attack_start", 0), anim.getMarker("attack_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 250.0f, p -> Mth.m_14031_((float)(p * (float)Math.PI)) * 50.0f, 0.0f)) != null) {
            handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 3.0f)).executeAttack());
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return true;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

