/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GloveAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), EnumSkills.FIST, 20), 0).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.GLOVES.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (anim.isAt("attack") && handler.getComboCount() != 5) {
            if (!entity.f_19853_.f_46443_) {
                if (handler.getComboCount() != 4) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(IAOEWeapon.createOBB((LivingEntity)entity, (ItemStack)stack, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0)))).executeAttack();
                } else {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new AABB(-1.0, -1.0, -1.0, 1.0, 1.5, 1.5).m_82383_(entity.m_20182_().m_82520_(0.0, 0.2, 0.0).m_82549_(entity.m_20184_().m_82541_().m_82490_(0.4))))).executeAttack();
                }
            }
            entity.m_5496_(SoundEvents.f_12316_, 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("step")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.2));
                break;
            }
            case 2: 
            case 3: {
                if (!anim.isAt("step")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.3));
                break;
            }
            case 4: {
                Vec3 dir;
                if (anim.isAt("jump")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(1.2).m_82520_(0.0, 0.9, 0.0));
                }
                if (anim.isAt("down")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(0.9).m_82520_(0.0, -0.5, 0.0));
                }
                entity.m_183634_();
                break;
            }
            case 5: {
                if (anim.isAt("leap")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
                    handler.resetHitEntityTracker();
                    Vec3 dir = CombatUtils.fromRelativeVector(handler.get(DataKey.SPIN_ROTATION).floatValue(), new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(2.7).m_82520_(0.0, 0.6, 0.0));
                }
                entity.m_183634_();
                if (anim.isAt("attack_start")) {
                    entity.m_5496_((SoundEvent)ModSounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.3f);
                }
                if (entity.f_19853_.f_46443_ || !anim.isPast("attack_start") || anim.isPast("attack_end")) break;
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82400_(0.5))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("move_start") && !anim.isPast("move_end"));
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> LevelCalc.useRP((Player)player, d, GeneralConfig.gloveUltimate, true, 0.0f, false, new EnumSkills[0]));
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return GeneralConfig.moveSpeedAttack.get().floatValue();
    }

    @Override
    public Pose getPose(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getAnimation() == null) {
            return null;
        }
        if (handler.getComboCount() == 5 && handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end")) {
            return Pose.SPIN_ATTACK;
        }
        return null;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 4;
    }
}

