/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GloveUseAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        return PlayerModelAnimations.GLOVES_USE.create(1.0f);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (anim.isPast("attack_start") && !handler.getAnimation().isPast("attack_end")) {
            Vec3 look = entity.m_20154_();
            Vec3 move = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_().m_82490_(entity.m_20096_() ? 0.5 : 0.3).m_82520_(0.0, entity.m_20184_().f_82480_, 0.0);
            entity.m_20256_(move);
            if (anim.isAt("reset")) {
                handler.resetHitEntityTracker();
            }
            if (!entity.f_19853_.f_46443_) {
                ArrayList hit = new ArrayList();
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82400_(1.0))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(hit::add).executeAttack());
                if (!hit.isEmpty() && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> LevelCalc.levelSkill(serverPlayer, data, EnumSkills.DUAL, 2.0f));
                }
            }
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        entity.f_19793_ = (float)((double)entity.f_19793_ + 0.5);
    }

    @Override
    public void onEnd(LivingEntity entity, AttackActionHandler handler) {
        entity.f_19793_ = (float)((double)entity.f_19793_ - 0.5);
    }

    @Override
    public Pose getPose(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getAnimation() == null) {
            return null;
        }
        if (handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end")) {
            return Pose.SPIN_ATTACK;
        }
        return null;
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

