/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemAxeBase;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class GrandImpactAttack
extends AttackAction {
    private final ComboContainer combos = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("attack_1") && !handler.getAnimation().isPast("combo_end")).addCombo(handler -> handler.getAnimation().isPast("attack_1") && !handler.getAnimation().isPast("combo_end")).addCombo(handler -> handler.getAnimation().isPast("attack_1") && !handler.getAnimation().isPast("combo_end")).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.GRAND_IMPACT.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (!entity.f_19853_.f_46443_ && (anim.isAt("attack_1") || anim.isAt("attack_2"))) {
            float reach = (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
            S2CScreenShake.sendAround((Entity)entity, 16.0, 6, 3.0f);
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, entity.m_5720_(), 1.0f, 1.0f);
            CombatUtils.applyTempAttribute(entity, Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack));
            ItemAxeBase.performRightClickAction(stack, entity, reach + 1.0f, 0.1f);
            CombatUtils.removeTempAttribute(entity, Attributes.f_22281_);
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combos;
    }
}

