/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class HammerAxeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), EnumSkills.HAMMERAXE, 20), 0).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.HAMMER_AXE.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (anim.isAt("attack") && handler.getComboCount() != 3) {
            CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(IAOEWeapon.createOBB((LivingEntity)entity, (ItemStack)stack, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0)))).executeAttack();
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 0.8f);
        }
        if (handler.getComboCount() == 3) {
            if (anim.isAt("spin_start")) {
                handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
                handler.resetHitEntityTracker();
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11893_, entity.m_5720_(), 0.7f, 0.5f);
            }
            if (anim.isAt("reset")) {
                handler.resetHitEntityTracker();
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11893_, entity.m_5720_(), 1.0f, 0.7f);
            }
            if (anim.isPast("spin_start") && !anim.isPast("spin_end")) {
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.35).m_82520_(0.0, 0.15, 0.0));
                }
                if (anim.isAt("spin_middle")) {
                    handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.35).m_82520_(0.0, -0.15, 0.0));
                }
                entity.m_183634_();
                if (!entity.f_19853_.f_46443_) {
                    handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82400_(1.0))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withAttackSound(SoundEvents.f_12316_).executeAttack());
                }
            } else {
                handler.store(DataKey.MOVE_DIRECTION, null);
            }
            handler.applyMoveDirection();
            handler.store(DataKey.FIXED_LOOK, anim.isPast("spin_start") && !anim.isPast("spin_end"));
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 3 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> LevelCalc.useRP((Player)player, d, GeneralConfig.hammerAxeUltimate, true, 0.0f, false, new EnumSkills[0]));
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 3;
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return GeneralConfig.moveSpeedAttack.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo != 3;
    }
}

