/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class HurricaneAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.HURRICANE.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        CombatUtils.EntityAttack attack;
        if (anim.isAt("attack_start")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_() + 180.0f));
            handler.resetHitEntityTracker();
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.2f);
        }
        if (anim.isAt("attack")) {
            if (!entity.f_19853_.f_46443_) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new AABB(-1.0, -0.1, 0.0, 0.5, (double)entity.m_20206_(), CombatUtils.getRange(entity, -0.5)), false)).executeAttack();
            }
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        if (anim.isAt("reset")) {
            handler.resetHitEntityTracker();
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.2f);
        }
        if (!entity.f_19853_.f_46443_ && (attack = HurricaneAttack.spinAttack(entity, anim, anim.getMarker("attack_start", 0), anim.getMarker("attack_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 1080.0f, 0.0f)) != null) {
            handler.addHitEntityTracker(attack.withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
        }
    }
}

