/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class NaiveBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("prepared")).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return PlayerModelAnimations.NAIVE_BLADE_SUCCESS.create(speed);
        }
        return PlayerModelAnimations.NAIVE_BLADE.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() == 2) {
            if (anim.isAt("jump")) {
                entity.m_20256_(new Vec3(0.0, 0.37, 0.0));
            }
            if (anim.isAt("attack_1")) {
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
                if (!entity.f_19853_.f_46443_) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(entity.m_146908_() - 150.0f, entity.m_146908_() + 150.0f, 0.0f)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.3f)).executeAttack();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.m_36346_();
                    }
                }
            }
            if (anim.isAt("attack_2")) {
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
                if (!entity.f_19853_.f_46443_) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.m_146908_(), 0.0f, 3.0, 0.0, false)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack();
                }
            }
        } else if (anim.isAt("prepared")) {
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11745_, entity.m_5720_(), 1.5f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            entity.m_5496_((SoundEvent)ModSounds.SPELL_NAIVE_BLADE.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 2;
    }

    public static boolean canCounter(AttackActionHandler handler) {
        AnimatedAction anim = handler.getAnimation();
        return handler.getCurrentAction() instanceof NaiveBladeAttack && anim != null && handler.getComboCount() == 1 && anim.isPast("prepared") && !anim.done(0);
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

