/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RapidMoveAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.RAPID_MOVE.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        Entity target = (Entity)handler.get(DataKey.TARGET);
        if (target != null) {
            Vec3 dir = target.m_20182_().m_82546_(entity.m_20182_());
            double width = 0.5 * (double)entity.m_20205_();
            double targetWidth = 0.5 * (double)target.m_20205_();
            double closeDist = width * width + targetWidth * targetWidth;
            closeDist += 1.0;
            if (dir.m_82556_() < closeDist) {
                entity.m_20256_(Vec3.f_82478_);
            } else {
                Vec3 motion = dir.m_82541_().m_82490_(1.0 + entity.m_21133_(Attributes.f_22279_) * 2.0);
                if (dir.m_82556_() < closeDist * 2.0) {
                    motion = dir.m_82490_(0.1);
                }
                entity.m_20256_(motion);
            }
            Vec3 direct = EntityUtils.getStraightProjectileTarget(entity.m_146892_(), target);
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, direct);
            entity.f_19864_ = true;
        }
        if (anim.isAt("attack")) {
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            if (!entity.f_19853_.f_46443_) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82400_(0.5).m_82363_(0.0, 0.0, 1.0))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack());
            }
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        LivingEntity target;
        super.onStart(entity, handler);
        if (!entity.f_19853_.m_5776_() && (target = entity.f_19853_.m_45963_(LivingEntity.class, TargetingConditions.m_148352_(), entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_142469_().m_82377_(20.0, 10.0, 20.0))) != null) {
            handler.store(DataKey.TARGET, target);
        }
    }
}

