/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RushAttack
extends AttackAction {
    private final ComboContainer combo;

    public RushAttack() {
        Predicate<AttackActionHandler> MAIN = handler -> handler.getAnimation().isPast("chain_1_start") && !handler.getAnimation().isPast("chain_1_end") || handler.getAnimation().isPast("chain_2_start") && !handler.getAnimation().isPast("chain_2_end");
        Function<Integer, ComboContainer.ComboGetter> IDX = idx -> handler -> !handler.getAnimation().isPast("chain_1_end") ? idx : 6;
        this.combo = ComboContainer.Builder.builder().addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(handler -> handler.getAnimation().isPast("chain_2_start") && !handler.getAnimation().isPast("chain_2_end"), 0).build();
    }

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        comboIdx = comboIdx < 6 ? 0 : 1;
        return PlayerModelAnimations.RUSH_ATTACK.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() == 7) {
            if (anim.isAt("leap")) {
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(1.6).m_82520_(0.0, -0.6, 0.0));
            }
            if (anim.isAt("attack_start")) {
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
            entity.f_19789_ = 0.0f;
            if (!entity.f_19853_.f_46443_ && anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.m_146908_(), 0.0f, CombatUtils.getWidth(entity, 1.5), -1.0, false)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 0.8f)).executeAttack());
            }
        } else {
            Vec3 dir;
            if (anim.isAt("step")) {
                dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.2));
            }
            if (anim.isAt("jump")) {
                dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 12, 2, true, false, false));
            }
            entity.f_19789_ = 0.0f;
            if (anim.isAt("attack")) {
                if (!entity.f_19853_.f_46443_) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.m_146908_(), 0.0f, CombatUtils.getWidth(entity, 0.5), 0.5, false)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack();
                }
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void onSetup(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getAnimation() != null && handler.getComboCount() < 7 && handler.getAnimation().isPast("chain_2_start")) {
            handler.setComboCount(6);
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

