/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpearAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), EnumSkills.SPEAR, 20), 0).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.SPEAR.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() != 5 && anim.isAt("attack")) {
            if (!entity.f_19853_.f_46443_) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(IAOEWeapon.createOBB((LivingEntity)entity, (ItemStack)stack, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0)))).executeAttack();
            }
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
        switch (handler.getComboCount()) {
            case 1: 
            case 3: 
            case 4: {
                if (!anim.isAt("step")) break;
                entity.m_20256_(dir.m_82490_(0.3));
                break;
            }
            case 2: {
                if (!anim.isAt("step")) break;
                entity.m_20256_(dir.m_82490_(0.15));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
                    handler.resetHitEntityTracker();
                    entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
                }
                if ((attack = SpearAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 1260.0f, -1.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if (anim.isAt("leap")) {
                    entity.m_20256_(dir.m_82490_(1.3).m_82520_(0.0, 0.4, 0.0));
                }
                if (!anim.isAt("slam")) break;
                Vec3 look = entity.m_20154_();
                look = new Vec3(look.m_7096_(), 0.0, look.m_7094_()).m_82490_(1.2);
                Vec3 attackPos = entity.m_20182_().m_82520_(0.0, 0.2, 0.0).m_82549_(look);
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new AABB(-1.0, -1.2, 0.0, 1.0, 1.2, 2.5), false)).executeAttack();
                Vec3 pos = entity.m_20182_().m_82520_(0.0, -1.0, 0.0);
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                Vec3 axis = new Vec3(0.0, 1.0, 0.0);
                Vec3 dir2 = new Vec3(0.0, 0.0, 1.0).m_82490_(1.0);
                for (int i = -180; i < 180; i += 15) {
                    Level level;
                    Vec3 scaled = MathUtils.rotate((Vec3)axis, (Vec3)dir2, (float)i);
                    mut.m_122178_(Mth.m_14107_((double)(pos.m_7096_() + dir2.m_7096_())), Mth.m_14107_((double)pos.m_7098_()), Mth.m_14107_((double)(pos.m_7094_() + dir2.m_7094_())));
                    BlockState state = entity.f_19853_.m_8055_((BlockPos)mut);
                    if (state.m_60799_() == RenderShape.INVISIBLE || !((level = entity.m_183503_()) instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), attackPos.m_7096_() + scaled.m_7096_() + entity.m_20184_().m_7096_(), entity.m_20186_() + 0.1, attackPos.m_7094_() + scaled.m_7094_() + entity.m_20184_().m_7094_(), 0, (double)((float)scaled.m_7096_()), 1.5, (double)((float)scaled.m_7094_()), 1.0);
                }
                entity.m_5496_(SoundEvents.f_11892_, 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("leap") && !anim.isPast("leap_end"));
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> LevelCalc.useRP((Player)player, d, GeneralConfig.spearUltimate, true, 0.0f, false, new EnumSkills[0]));
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return GeneralConfig.moveSpeedAttack.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo != 5;
    }
}

