/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class StardustUpperAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.STARDUST_UPPER.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        Vec3 dir;
        if (anim.isAt("attack_start_1")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_() - 110.0f));
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            entity.m_20256_(dir.m_82490_(0.6));
        }
        if (anim.isAt("attack_start_2")) {
            handler.resetHitEntityTracker();
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            entity.m_20256_(dir.m_82490_(0.6));
        }
        if (!entity.f_19853_.f_46443_) {
            CombatUtils.EntityAttack attack2;
            CombatUtils.EntityAttack attack = StardustUpperAttack.spinAttack(entity, anim, anim.getMarker("attack_start_1", 0), anim.getMarker("attack_end_1", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 410.0f, 0.0f);
            if (attack != null) {
                handler.addHitEntityTracker(attack.withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
            if ((attack2 = StardustUpperAttack.spinAttack(entity, anim, anim.getMarker("attack_start_2", 0), anim.getMarker("attack_end_2", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 410.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 680.0f, p -> Mth.m_14031_((float)(p * (float)Math.PI)) * 50.0f, 0.0f)) != null) {
                handler.addHitEntityTracker(attack2.withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(target -> {
                    CombatUtils.knockBackEntity(entity, target, 0.4f);
                    target.m_20256_(target.m_20184_().m_82520_(0.0, 0.3, 0.0));
                }).executeAttack());
            }
        }
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

