/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class StormAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.STORM.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (anim.isAt("attack") && handler.getComboCount() != 5) {
            if (!entity.f_19853_.f_46443_) {
                double range = CombatUtils.getRange(entity, 0.0) * 0.5;
                if (handler.getComboCount() == 3) {
                    range *= 2.0;
                }
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.m_146908_(), 0.0f, range, 0.5, false)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack();
            }
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("move")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.2).m_82520_(0.0, 0.1, 0.0));
                break;
            }
            case 2: {
                if (!anim.isAt("move")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.3));
                break;
            }
            case 3: {
                if (!anim.isAt("move")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.2));
                break;
            }
            case 4: {
                if (anim.isAt("up")) {
                    Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(0.15).m_82520_(0.0, 0.05, 0.0));
                }
                if (!anim.isAt("down")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.m_20256_(dir.m_82490_(0.15).m_82520_(0.0, -0.05, 0.0));
                break;
            }
            case 5: {
                if (anim.isAt("up")) {
                    Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(0.2).m_82520_(0.0, 0.15, 0.0));
                }
                if (anim.isAt("down")) {
                    Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.m_20256_(dir.m_82490_(0.25).m_82520_(0.0, -0.35, 0.0));
                }
                handler.applyMoveDirection();
                entity.f_19789_ = 0.0f;
                if (!anim.isAt("attack")) break;
                if (!entity.f_19853_.f_46443_) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82377_(1.0, 0.5, 0.0).m_82363_(0.0, -1.0, CombatUtils.getRange(entity, 0.0)))).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.1f)).executeAttack();
                }
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        handler.store(DataKey.GRAVITY, entity.m_20068_());
        entity.m_20242_(true);
    }

    @Override
    public void onEnd(LivingEntity entity, AttackActionHandler handler) {
        handler.clearWith(DataKey.GRAVITY, arg_0 -> ((LivingEntity)entity).m_20242_(arg_0));
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

