/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.function.BiConsumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class TimedUseAttack
extends AttackAction {
    private final AnimatedAction animation;
    private final boolean ignoreAttackSpeed;
    private final BiConsumer<LivingEntity, ItemStack> attack;
    private final boolean mountedUse;

    public TimedUseAttack(AnimatedAction animation, BiConsumer<LivingEntity, ItemStack> attack) {
        this(animation, false, attack, true);
    }

    public TimedUseAttack(AnimatedAction animation, boolean ignoreAttackSpeed, BiConsumer<LivingEntity, ItemStack> attack, boolean mountedUse) {
        this.animation = animation;
        this.ignoreAttackSpeed = ignoreAttackSpeed;
        this.attack = attack;
        this.mountedUse = mountedUse;
    }

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        if (!this.ignoreAttackSpeed) {
            return this.animation.create(1.0f);
        }
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return this.animation.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        if (!entity.f_19853_.f_46443_ && anim.isAt("attack")) {
            entity.m_6674_(InteractionHand.MAIN_HAND);
            this.attack.accept(entity, stack);
        }
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return this.mountedUse;
    }
}

