/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class TornadoSwingAttack
extends AttackAction {
    private final ComboContainer combo;

    public TornadoSwingAttack() {
        Predicate<AttackActionHandler> MAIN = handler -> handler.getAnimation().isAt("attack_end_1");
        this.combo = ComboContainer.Builder.builder().addCombo(MAIN).addCombo(MAIN).addCombo(MAIN).build();
    }

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        if (comboIdx > 0) {
            float offset = (float)(PlayerModelAnimations.TORNADO_SWING.getMarker("chain_offset", 0) * 20.0);
            return PlayerModelAnimations.TORNADO_SWING.create(0, -1, offset, speed);
        }
        return PlayerModelAnimations.TORNADO_SWING.create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        CombatUtils.EntityAttack attack;
        if (anim.isAt("attack_start_1")) {
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 0.8f);
        }
        if (anim.isAt("attack_start_2")) {
            handler.resetHitEntityTracker();
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 0.8f);
        }
        if ((attack = TornadoSwingAttack.spinAttack(entity, anim, anim.getMarker("attack_start_1", 0), anim.getMarker("attack_end_1", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 110.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() - 285.0f, 0.5f)) != null) {
            handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack());
        }
        if ((attack = TornadoSwingAttack.spinAttack(entity, anim, anim.getMarker("attack_start_2", 0), anim.getMarker("attack_end_2", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 75.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() - 35.0f, 0.5f)) != null) {
            handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).executeAttack());
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
        if (handler.getComboCount() != 1) {
            entity.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 0.8f);
        }
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return 0.6f;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

