/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WaterLaserAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> true, 0).build();
    private final int type;

    public WaterLaserAttack(int type) {
        this.type = type;
    }

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return PlayerModelAnimations.WATER_LASER_END.create(speed);
        }
        return switch (this.type) {
            case 2 -> PlayerModelAnimations.WATER_LASER_THREE.create(speed);
            case 1 -> PlayerModelAnimations.WATER_LASER_TWO.create(speed);
            default -> PlayerModelAnimations.WATER_LASER_ONE.create(speed);
        };
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        block6: {
            block7: {
                if (handler.getComboCount() != 1) break block6;
                Level level = entity.m_183503_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (anim.isAt("attack")) {
                        Spell spell;
                        entity.m_6674_(InteractionHand.MAIN_HAND);
                        if (handler.get(DataKey.USED_SPELL) != null && (spell = handler.get(DataKey.USED_SPELL)).use(serverLevel, entity, stack) && entity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            spell.levelSkill(player);
                        }
                    }
                }
                if (entity.f_19853_.f_46443_ || !anim.isPast("continue")) break block6;
                if (!(entity instanceof ServerPlayer)) break block7;
                ServerPlayer player = (ServerPlayer)entity;
                if (!entity.m_21211_().m_41619_() || !Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.getInv().getInUseStack() != handler.get(DataKey.USED_WEAPON)).orElse(false).booleanValue()) break block6;
            }
            handler.doWeaponAttack(this, handler.get(DataKey.USED_WEAPON), handler.get(DataKey.USED_SPELL));
        }
    }

    @Override
    public AttackAction onChange(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 1) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Spell spell = handler.get(DataKey.USED_SPELL);
                ItemStack stack = handler.get(DataKey.USED_WEAPON);
                if (stack.m_41720_() instanceof ItemSpell) {
                    player.m_36335_().m_41524_(stack.m_41720_(), spell.coolDown());
                }
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

