/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class WindSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("chain_start") && !handler.getAnimation().isPast("spin_end")).build();

    @Override
    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.WIND_SLASH.get(comboIdx).create(speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
        Vec3 dir;
        handler.store(DataKey.FIXED_LOOK, true);
        if (anim.isAt("spin_start")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
            handler.resetHitEntityTracker();
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11893_, entity.m_5720_(), 0.7f, 0.5f);
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.35));
        }
        if (anim.isAt("reset")) {
            handler.resetHitEntityTracker();
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11893_, entity.m_5720_(), 1.0f, 0.7f);
        }
        if (anim.isAt("leap")) {
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.35).m_82520_(0.0, 0.3, 0.0));
        }
        if (anim.isAt("spin_end")) {
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        if (anim.isPast("spin_start") && !anim.isPast("spin_end")) {
            entity.m_183634_();
            if (!entity.f_19853_.f_46443_) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.m_142469_().m_82400_(0.75))).withBonusAttributesMultiplier(Attributes.f_22281_, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        handler.applyMoveDirection();
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.m_146908_()));
            handler.resetHitEntityTracker();
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11893_, entity.m_5720_(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 0.7f);
            Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.m_82490_(0.35));
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

