/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.api.enums.EnumMineralTier;
import io.github.flemmli97.runecraftory.common.blocks.tile.BrokenMineralBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBrokenMineral
extends Block
implements SimpleWaterloggedBlock,
EntityBlock,
ExtendedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)5.0), Block.m_49796_((double)10.0, (double)0.0, (double)8.0, (double)13.0, (double)1.0, (double)10.0), Block.m_49796_((double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0, (double)15.0), Block.m_49796_((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)3.0, (double)10.0), Block.m_49796_((double)3.0, (double)0.0, (double)10.0, (double)9.0, (double)2.0, (double)14.0), Block.m_49796_((double)6.0, (double)0.0, (double)3.0, (double)8.0, (double)1.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)1.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)6.0, (double)3.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)1.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)10.0), Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)13.0, (double)2.0, (double)8.0), Block.m_49796_((double)10.0, (double)0.3, (double)9.0, (double)12.0, (double)1.3, (double)10.0), Block.m_49796_((double)6.75, (double)1.55, (double)4.5, (double)8.75, (double)2.55, (double)7.5), Block.m_49796_((double)3.75, (double)1.55, (double)9.5, (double)5.75, (double)2.55, (double)11.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape WEST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)5.0, (double)1.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)3.0, (double)10.0, (double)1.0, (double)6.0), Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)7.0), Block.m_49796_((double)8.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0), Block.m_49796_((double)10.0, (double)0.0, (double)7.0, (double)14.0, (double)2.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)8.0, (double)4.0, (double)1.0, (double)10.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)3.0, (double)1.0, (double)14.0), Block.m_49796_((double)3.0, (double)0.0, (double)10.0, (double)10.0, (double)3.0, (double)15.0), Block.m_49796_((double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)10.0, (double)2.0, (double)3.0), Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)8.0, (double)2.0, (double)10.0), Block.m_49796_((double)9.0, (double)0.3, (double)4.0, (double)10.0, (double)1.3, (double)6.0), Block.m_49796_((double)4.5, (double)1.55, (double)7.25, (double)7.5, (double)2.55, (double)9.25), Block.m_49796_((double)9.5, (double)1.55, (double)10.25, (double)11.5, (double)2.55, (double)12.25)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SOUTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)8.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)7.0, (double)1.0, (double)6.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)8.0), Block.m_49796_((double)7.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0, (double)6.0), Block.m_49796_((double)8.0, (double)0.0, (double)12.0, (double)10.0, (double)1.0, (double)13.0), Block.m_49796_((double)9.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0, (double)15.0), Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)15.0, (double)3.0, (double)13.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)6.0), Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)3.0, (double)2.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)8.0, (double)10.0, (double)2.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.3, (double)6.0, (double)6.0, (double)1.3, (double)7.0), Block.m_49796_((double)7.25, (double)1.55, (double)8.5, (double)9.25, (double)2.55, (double)11.5), Block.m_49796_((double)10.25, (double)1.55, (double)4.5, (double)12.25, (double)2.55, (double)6.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape EAST = Stream.of(Block.m_49796_((double)11.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)8.0, (double)1.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)6.0, (double)1.0, (double)16.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)8.0, (double)3.0, (double)10.0), Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)6.0, (double)2.0, (double)9.0), Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)13.0, (double)1.0, (double)8.0), Block.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)7.0), Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)6.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)3.0), Block.m_49796_((double)6.0, (double)0.0, (double)13.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)2.0, (double)13.0), Block.m_49796_((double)6.0, (double)0.3, (double)10.0, (double)7.0, (double)1.3, (double)12.0), Block.m_49796_((double)8.5, (double)1.55, (double)6.75, (double)11.5, (double)2.55, (double)8.75), Block.m_49796_((double)4.5, (double)1.55, (double)3.75, (double)6.5, (double)2.55, (double)5.75)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public final EnumMineralTier tier;

    public BlockBrokenMineral(EnumMineralTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(ctx.m_43723_() != null ? ctx.m_43723_().m_6350_().m_122424_() : Direction.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_) {
            level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, state.m_60819_().m_76152_(), Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.FULL);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.f_46443_) {
            return false;
        }
        if (player.m_7500_() || player.m_6144_()) {
            this.m_5707_(level, pos, state, player);
            return level.m_7731_(pos, fluid.m_76188_(), 3);
        }
        return false;
    }

    public BlockState getMineralState(BlockState state) {
        BlockState blockState = ((Block)ModBlocks.MINERAL_MAP.get((Object)this.tier).get()).m_49966_();
        if (state.m_61138_((Property)FACING)) {
            state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        }
        if (state.m_61138_((Property)WATERLOGGED)) {
            state.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        }
        return blockState;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BrokenMineralBlockEntity(pos, state);
    }
}

