/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.blocks.tile.CraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.UpgradingCraftingBlockEntity;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BlockCrafting
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.m_61587_((String)"part", EnumPart.class);
    private final EnumCrafting type;

    public BlockCrafting(EnumCrafting type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
    }

    public static VoxelShape[] joinedOrDirs(ShapeBuilder ... shapes) {
        return new VoxelShape[]{BlockCrafting.joinedOr(Direction.SOUTH, shapes), BlockCrafting.joinedOr(Direction.WEST, shapes), BlockCrafting.joinedOr(Direction.NORTH, shapes), BlockCrafting.joinedOr(Direction.EAST, shapes)};
    }

    public static VoxelShape joinedOr(Direction direction, ShapeBuilder ... shapes) {
        return Stream.of(shapes).map(s -> {
            switch (direction) {
                case EAST: {
                    return Block.m_49796_((double)(16.0 - s.z2), (double)s.y1, (double)s.x1, (double)(16.0 - s.z1), (double)s.y2, (double)s.x2);
                }
                case SOUTH: {
                    return Block.m_49796_((double)(16.0 - s.x2), (double)s.y1, (double)(16.0 - s.z2), (double)(16.0 - s.x1), (double)s.y2, (double)(16.0 - s.z1));
                }
                case WEST: {
                    return Block.m_49796_((double)s.z1, (double)s.y1, (double)(16.0 - s.x2), (double)s.z2, (double)s.y2, (double)(16.0 - s.x1));
                }
            }
            return Block.m_49796_((double)s.x1, (double)s.y1, (double)s.z1, (double)s.x2, (double)s.y2, (double)s.z2);
        }).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    public BlockState m_7417_(BlockState state, Direction fromDir, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        if (state.m_61143_(PART) == EnumPart.RIGHT) {
            return fromDir == dir.m_122427_() && !this.isEqual(state, fromState) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, fromDir, fromState, level, pos, fromPos);
        }
        return fromDir == dir.m_122428_() && !this.isEqual(state, fromState) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, fromDir, fromState, level, pos, fromPos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState orig, boolean moving) {
        if (!state.m_60713_(orig.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CraftingBlockEntity) {
                CraftingBlockEntity craftingBlock = (CraftingBlockEntity)blockEntity;
                craftingBlock.dropContents(level, pos);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, orig, moving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof CraftingBlockEntity)) {
            pos = this.getOtherPos(pos, state);
            tile = level.m_7702_(pos);
        }
        if (tile instanceof CraftingBlockEntity) {
            CraftingBlockEntity craftingBlock = (CraftingBlockEntity)tile;
            if (player.m_6144_() && craftingBlock instanceof UpgradingCraftingBlockEntity) {
                UpgradingCraftingBlockEntity upgrading = (UpgradingCraftingBlockEntity)craftingBlock;
                Platform.INSTANCE.openGuiMenu((ServerPlayer)player, upgrading.upgradeMenu(), pos);
            } else {
                Platform.INSTANCE.openGuiMenu((ServerPlayer)player, (MenuProvider)craftingBlock, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        if (state.m_61143_(PART) == EnumPart.LEFT) {
            return true;
        }
        BlockState blockstate = reader.m_8055_(this.getOtherPos(pos, state));
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) && blockstate.m_61143_(PART) == EnumPart.RIGHT;
    }

    private boolean isEqual(BlockState one, BlockState other) {
        return other.m_60734_() == one.m_60734_() && other.m_61143_((Property)f_54117_) == one.m_61143_((Property)f_54117_) && other.m_61143_(PART) != one.m_61143_(PART);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        if (ctx.m_43725_().m_8055_(blockpos).m_60629_(ctx)) {
            BlockPos other = blockpos.m_142300_(ctx.m_8125_().m_122424_().m_122428_());
            if (ctx.m_43725_().m_8055_(other).m_60629_(ctx)) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(PART, (Comparable)((Object)EnumPart.LEFT));
            }
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        super.m_6402_(level, pos, state, living, stack);
        if (!level.f_46443_) {
            level.m_7731_(pos.m_142300_(living.m_6350_().m_122424_().m_122428_()), (BlockState)state.m_61124_(PART, (Comparable)((Object)EnumPart.RIGHT)), 3);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState other;
        BlockPos blockPos = this.getOtherPos(pos, state);
        if (!level.f_46443_ && player.m_7500_() && state.m_61143_(PART) == EnumPart.RIGHT && (other = level.m_8055_(blockPos)).m_60713_((Block)this) && other.m_61143_(PART) == EnumPart.LEFT) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)other));
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(PART) == EnumPart.LEFT) {
            return this.createNewBlockEntity(pos, state);
        }
        return null;
    }

    protected abstract BlockEntity createNewBlockEntity(BlockPos var1, BlockState var2);

    public BlockPos getOtherPos(BlockPos from, BlockState state) {
        if (state.m_61143_(PART) == EnumPart.RIGHT) {
            return from.m_142300_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
        }
        return from.m_142300_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
    }

    public boolean hasUpgradeScreen() {
        return this.type == EnumCrafting.ARMOR || this.type == EnumCrafting.FORGE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()));
    }

    public record ShapeBuilder(double x1, double y1, double z1, double x2, double y2, double z2) {
        public static ShapeBuilder of(double x1, double y1, double z1, double x2, double y2, double z2) {
            return new ShapeBuilder(x1, y1, z1, x2, y2, z2);
        }
    }

    public static enum EnumPart implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right");

        private final String s;

        private EnumPart(String s) {
            this.s = s;
        }

        public String m_7912_() {
            return this.s;
        }
    }
}

