/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.common.blocks.BlockCrafting;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockGiantCrop
extends BlockCrop {
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.f_61374_;
    private static final List<Direction> DIRECTIONS = Direction.Plane.HORIZONTAL.m_122557_().sorted(Comparator.comparingInt(Direction::m_122416_)).toList();
    private static final VoxelShape[] SHAPE = BlockCrafting.joinedOrDirs(BlockCrafting.ShapeBuilder.of(0.0, 0.0, 0.0, 13.0, 12.0, 13.0));

    public BlockGiantCrop(BlockBehaviour.Properties prop, Supplier<Item> giant, Supplier<Item> seed) {
        super(prop, giant, seed);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE[((Direction)state.m_61143_(DIRECTION)).m_122416_()];
    }

    @Override
    public IntegerProperty m_7959_() {
        return AGE;
    }

    @Override
    public int m_7419_() {
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Direction dir = (Direction)state.m_61143_(DIRECTION);
        if (!(direction != dir || neighborState.m_60713_((Block)this) && ((Direction)neighborState.m_61143_(DIRECTION)).m_122427_() == dir)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            BlockPos.MutableBlockPos mut = pos.m_122032_();
            Direction dir = (Direction)state.m_61143_(DIRECTION);
            for (int i = 0; i < 3; ++i) {
                Direction blockDir;
                BlockState blockAt = level.m_8055_((BlockPos)mut.m_122173_(dir));
                if (!blockAt.m_60713_((Block)this) || (Integer)blockAt.m_61143_((Property)AGE) != 1 || (blockDir = (Direction)blockAt.m_61143_(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.m_61143_(DIRECTION)).m_122416_()) % 4)) continue;
                level.m_7731_((BlockPos)mut, Blocks.f_50016_.m_49966_(), 3);
                level.m_5898_(player, 2001, (BlockPos)mut, Block.m_49956_((BlockState)blockAt));
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{BlockCrop.WILTED}).m_61104_(new Property[]{DIRECTION});
    }

    @Override
    public int getGiantAge() {
        return 0;
    }

    @Override
    public void onWither(int amount, Level level, BlockState state, BlockPos pos) {
        super.onWither(amount, level, state, pos);
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        Direction dir = (Direction)state.m_61143_(DIRECTION);
        for (int i = 0; i < 3; ++i) {
            Direction blockDir;
            BlockState blockAt = level.m_8055_((BlockPos)mut.m_122173_(dir));
            if (!blockAt.m_60713_((Block)this) || (Integer)blockAt.m_61143_((Property)AGE) != 1 || (blockDir = (Direction)blockAt.m_61143_(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.m_61143_(DIRECTION)).m_122416_()) % 4)) continue;
            dir = blockDir;
            super.onWither(amount, level, blockAt, (BlockPos)mut);
        }
    }

    @Override
    public void onWiltedWatering(Level level, BlockPos pos, BlockState state) {
        super.onWiltedWatering(level, pos, state);
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        Direction dir = (Direction)state.m_61143_(DIRECTION);
        for (int i = 0; i < 3; ++i) {
            Direction blockDir;
            BlockState blockAt = level.m_8055_((BlockPos)mut.m_122173_(dir));
            if (!blockAt.m_60713_((Block)this) || (Integer)blockAt.m_61143_((Property)AGE) != 1 || (blockDir = (Direction)blockAt.m_61143_(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.m_61143_(DIRECTION)).m_122416_()) % 4)) continue;
            dir = blockDir;
            level.m_7731_((BlockPos)mut, (BlockState)blockAt.m_61124_((Property)BlockCrop.WILTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

