/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.api.enums.EnumMineralTier;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockMineral
extends Block
implements SimpleWaterloggedBlock,
ExtendedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)5.0), Block.m_49796_((double)10.0, (double)0.0, (double)8.0, (double)13.0, (double)11.0, (double)10.0), Block.m_49796_((double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)8.0, (double)10.0), Block.m_49796_((double)3.0, (double)0.0, (double)10.0, (double)9.0, (double)5.0, (double)14.0), Block.m_49796_((double)6.0, (double)0.0, (double)3.0, (double)8.0, (double)4.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)2.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)6.0, (double)11.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)10.0), Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)13.0, (double)15.0, (double)8.0), Block.m_49796_((double)4.0, (double)5.0, (double)10.0, (double)7.0, (double)6.0, (double)11.0), Block.m_49796_((double)11.0, (double)5.5, (double)10.3, (double)12.0, (double)6.5, (double)12.3), Block.m_49796_((double)12.8, (double)4.8, (double)5.3, (double)14.8, (double)5.8, (double)9.3), Block.m_49796_((double)1.4, (double)1.3, (double)9.6, (double)4.4, (double)2.3, (double)11.6), Block.m_49796_((double)7.1, (double)4.5, (double)12.8, (double)10.1, (double)5.5, (double)13.8), Block.m_49796_((double)3.6, (double)10.4, (double)7.0, (double)5.6, (double)11.4, (double)9.0), Block.m_49796_((double)3.6, (double)6.4, (double)2.5, (double)5.6, (double)7.4, (double)3.5), Block.m_49796_((double)6.6, (double)2.4, (double)2.5, (double)8.6, (double)3.4, (double)3.5), Block.m_49796_((double)10.6, (double)11.4, (double)7.5, (double)11.6, (double)12.4, (double)8.5), Block.m_49796_((double)8.6, (double)8.4, (double)3.5, (double)11.6, (double)10.4, (double)4.5), Block.m_49796_((double)0.6, (double)5.0, (double)4.2, (double)1.6, (double)7.0, (double)8.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape WEST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)5.0, (double)6.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)3.0, (double)10.0, (double)11.0, (double)6.0), Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)15.0, (double)6.0, (double)7.0), Block.m_49796_((double)8.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.m_49796_((double)10.0, (double)0.0, (double)7.0, (double)14.0, (double)5.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)8.0, (double)4.0, (double)4.0, (double)10.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)3.0, (double)2.0, (double)14.0), Block.m_49796_((double)3.0, (double)0.0, (double)10.0, (double)10.0, (double)11.0, (double)15.0), Block.m_49796_((double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)10.0, (double)5.0, (double)3.0), Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)8.0, (double)15.0, (double)10.0), Block.m_49796_((double)10.0, (double)5.0, (double)9.0, (double)11.0, (double)6.0, (double)12.0), Block.m_49796_((double)10.3, (double)5.5, (double)4.0, (double)12.3, (double)6.5, (double)5.0), Block.m_49796_((double)5.3, (double)4.8, (double)1.2, (double)9.3, (double)5.8, (double)3.2), Block.m_49796_((double)9.6, (double)1.3, (double)11.6, (double)11.6, (double)2.3, (double)14.6), Block.m_49796_((double)12.8, (double)4.5, (double)5.9, (double)13.8, (double)5.5, (double)8.9), Block.m_49796_((double)7.0, (double)10.4, (double)10.4, (double)9.0, (double)11.4, (double)12.4), Block.m_49796_((double)2.5, (double)6.4, (double)10.4, (double)3.5, (double)7.4, (double)12.4), Block.m_49796_((double)2.5, (double)2.4, (double)7.4, (double)3.5, (double)3.4, (double)9.4), Block.m_49796_((double)7.5, (double)11.4, (double)4.4, (double)8.5, (double)12.4, (double)5.4), Block.m_49796_((double)3.5, (double)8.4, (double)4.4, (double)4.5, (double)10.4, (double)7.4), Block.m_49796_((double)4.2, (double)5.0, (double)14.4, (double)8.2, (double)7.0, (double)15.4)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SOUTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)8.0, (double)6.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)11.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)7.0, (double)6.0, (double)6.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)8.0), Block.m_49796_((double)7.0, (double)0.0, (double)2.0, (double)13.0, (double)5.0, (double)6.0), Block.m_49796_((double)8.0, (double)0.0, (double)12.0, (double)10.0, (double)4.0, (double)13.0), Block.m_49796_((double)9.0, (double)0.0, (double)13.0, (double)14.0, (double)2.0, (double)15.0), Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)15.0, (double)11.0, (double)13.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)6.0), Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)3.0, (double)5.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)8.0, (double)10.0, (double)15.0, (double)12.0), Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)12.0, (double)6.0, (double)6.0), Block.m_49796_((double)4.0, (double)5.5, (double)3.7, (double)5.0, (double)6.5, (double)5.7), Block.m_49796_((double)1.2, (double)4.8, (double)6.7, (double)3.2, (double)5.8, (double)10.7), Block.m_49796_((double)11.6, (double)1.3, (double)4.4, (double)14.6, (double)2.3, (double)6.4), Block.m_49796_((double)5.9, (double)4.5, (double)2.2, (double)8.9, (double)5.5, (double)3.2), Block.m_49796_((double)10.4, (double)10.4, (double)7.0, (double)12.4, (double)11.4, (double)9.0), Block.m_49796_((double)10.4, (double)6.4, (double)12.5, (double)12.4, (double)7.4, (double)13.5), Block.m_49796_((double)7.4, (double)2.4, (double)12.5, (double)9.4, (double)3.4, (double)13.5), Block.m_49796_((double)4.4, (double)11.4, (double)7.5, (double)5.4, (double)12.4, (double)8.5), Block.m_49796_((double)4.4, (double)8.4, (double)11.5, (double)7.4, (double)10.4, (double)12.5), Block.m_49796_((double)14.4, (double)5.0, (double)7.8, (double)15.4, (double)7.0, (double)11.8)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape EAST = Stream.of(Block.m_49796_((double)11.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0, (double)13.0), Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)8.0, (double)11.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)6.0, (double)6.0, (double)16.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)8.0, (double)8.0, (double)10.0), Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)6.0, (double)5.0, (double)9.0), Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)13.0, (double)4.0, (double)8.0), Block.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0, (double)7.0), Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)13.0, (double)11.0, (double)6.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)2.0, (double)3.0), Block.m_49796_((double)6.0, (double)0.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)15.0, (double)13.0), Block.m_49796_((double)5.0, (double)5.0, (double)4.0, (double)6.0, (double)6.0, (double)7.0), Block.m_49796_((double)3.7, (double)5.5, (double)11.0, (double)5.7, (double)6.5, (double)12.0), Block.m_49796_((double)6.7, (double)4.8, (double)12.8, (double)10.7, (double)5.8, (double)14.8), Block.m_49796_((double)4.4, (double)1.3, (double)1.4, (double)6.4, (double)2.3, (double)4.4), Block.m_49796_((double)2.23, (double)4.5, (double)7.1, (double)3.23, (double)5.5, (double)10.1), Block.m_49796_((double)7.0, (double)10.4, (double)3.6, (double)9.0, (double)11.4, (double)5.6), Block.m_49796_((double)12.5, (double)6.4, (double)3.6, (double)13.5, (double)7.4, (double)5.6), Block.m_49796_((double)12.5, (double)2.4, (double)6.6, (double)13.5, (double)3.4, (double)8.6), Block.m_49796_((double)7.5, (double)11.4, (double)10.6, (double)8.5, (double)12.4, (double)11.6), Block.m_49796_((double)11.5, (double)8.4, (double)8.6, (double)12.5, (double)10.4, (double)11.6), Block.m_49796_((double)7.8, (double)5.0, (double)0.6, (double)11.8, (double)7.0, (double)1.6)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public final EnumMineralTier tier;

    public BlockMineral(EnumMineralTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(ctx.m_43723_() != null ? ctx.m_43723_().m_6350_().m_122424_() : Direction.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_) {
            level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Entity entity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
                float addChance = (float)data.getSkillLevel(EnumSkills.MINING).getLevel() * 0.03f;
                Item patt9951$temp = player.m_21205_().m_41720_();
                if (patt9951$temp instanceof ItemToolHammer) {
                    ItemToolHammer item = (ItemToolHammer)patt9951$temp;
                    addChance = (float)((double)addChance + (double)item.tier.getTierLevel() * 0.75);
                }
                builder.m_78963_(addChance + EntityUtils.playerLuck(player));
            });
        }
        return super.m_7381_(state, builder);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.FULL);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float f = super.m_5880_(state, player, level, pos);
        return player.m_21205_().m_204117_(RunecraftoryTags.HAMMER_TOOLS) ? f : f * 0.5f;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.m_7500_()) {
            this.m_5707_(level, pos, state, player);
            return level.m_7731_(pos, fluid.m_76188_(), 3);
        }
        if (player.m_36298_(state)) {
            pos = pos.m_7949_();
            float breakChance = 0.7f;
            Item item = player.m_21205_().m_41720_();
            if (item instanceof ItemToolHammer) {
                ItemToolHammer hammer = (ItemToolHammer)item;
                breakChance -= (float)(hammer.tier.getTierLevel() + 1) * 0.05f;
            }
            this.m_5707_(level, pos, state, player);
            if (level.f_46441_.nextFloat() < breakChance) {
                return level.m_7731_(pos, this.getBrokenState(state), 3);
            }
            BlockMineral.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(pos, state));
            return false;
        }
        return false;
    }

    public BlockState getBrokenState(BlockState state) {
        BlockState blockState = ((Block)ModBlocks.BROKEN_MINERAL_MAP.get((Object)this.tier).get()).m_49966_();
        if (blockState.m_61138_((Property)FACING)) {
            blockState.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        }
        if (blockState.m_61138_((Property)WATERLOGGED)) {
            blockState.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        }
        return blockState;
    }
}

