/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.runecraftory.common.blocks.tile.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockMonsterBarn
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public BlockMonsterBarn(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MonsterBarnBlockEntity) {
                MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
                barn.setOwner(player.m_142081_());
            }
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        UUID owner;
        block5: {
            block4: {
                owner = null;
                if (player.m_7500_()) break block4;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof MonsterBarnBlockEntity)) break block5;
                MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
                owner = barn.getOwner();
                if (!player.m_142081_().equals(owner)) break block5;
            }
            return super.m_5880_(state, player, level, pos);
        }
        if (!player.f_19853_.f_46443_ && owner != null) {
            UUID uuid = owner;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> {
                if (d.onBarnFailMine(pos)) {
                    player.m_6352_((Component)new TranslatableComponent("runecraftory.barn.interact.not.owner", new Object[]{player.m_20194_().m_129927_().m_11002_(uuid).map(GameProfile::getName).orElse("UNKNOWN")}).m_130940_(ChatFormatting.DARK_RED), Util.f_137441_);
                }
            });
        }
        return 0.0f;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MonsterBarnBlockEntity) {
            MonsterBarnBlockEntity barn = (MonsterBarnBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                WorldHandler.get(serverLevel.m_142572_()).removeBarn(barn.getOwner(), GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        UUID owner;
        block2: {
            MonsterBarnBlockEntity barn;
            block3: {
                if (level.f_46443_) return InteractionResult.SUCCESS;
                owner = null;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof MonsterBarnBlockEntity)) break block2;
                barn = (MonsterBarnBlockEntity)blockEntity;
                if (player.m_7500_()) break block3;
                owner = barn.getOwner();
                if (!player.m_142081_().equals(owner)) break block2;
            }
            if (barn.getBarnData() == null) return InteractionResult.CONSUME;
            String key = barn.getBarnData().hasRoof() ? "runecraftory.barn.interact.block.roofed" : "runecraftory.barn.interact.block";
            player.m_6352_((Component)new TranslatableComponent(key, new Object[]{barn.getBarnData().getCapacity(), barn.getBarnData().getCapacity() - barn.getBarnData().usedCapacity()}).m_130940_(barn.getBarnData().getCapacity() > 0 ? ChatFormatting.GOLD : ChatFormatting.DARK_RED), Util.f_137441_);
            return InteractionResult.CONSUME;
        }
        if (owner == null) return InteractionResult.CONSUME;
        UUID uuid = owner;
        Platform.INSTANCE.getPlayerData(player).ifPresent(d -> {
            if (d.onBarnFailMine(pos)) {
                player.m_6352_((Component)new TranslatableComponent("runecraftory.barn.interact.not.owner", new Object[]{player.m_20194_().m_129927_().m_11002_(uuid).map(GameProfile::getName).orElse("UNKNOWN")}).m_130940_(ChatFormatting.DARK_RED), Util.f_137441_);
            }
        });
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MonsterBarnBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.MONSTER_BARN_BLOCK_ENTITY.get()), MonsterBarnBlockEntity::tick);
    }
}

