/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrafting;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockQuestboard
extends HorizontalDirectionalBlock {
    public static final VoxelShape[] BOTTOM_LEFT = BlockCrafting.joinedOrDirs(BlockCrafting.ShapeBuilder.of(0.0, 0.0, 7.0, 2.0, 10.0, 9.0), BlockCrafting.ShapeBuilder.of(1.0, 11.0, 6.5, 16.0, 16.0, 9.5), BlockCrafting.ShapeBuilder.of(0.0, 10.0, 6.0, 1.0, 16.0, 10.0), BlockCrafting.ShapeBuilder.of(1.0, 10.0, 6.0, 16.0, 11.0, 10.0));
    public static final VoxelShape[] BOTTOM_RIGHT = BlockCrafting.joinedOrDirs(BlockCrafting.ShapeBuilder.of(14.0, 0.0, 7.0, 16.0, 10.0, 9.0), BlockCrafting.ShapeBuilder.of(0.0, 11.0, 6.5, 15.0, 16.0, 9.5), BlockCrafting.ShapeBuilder.of(15.0, 10.0, 6.0, 16.0, 16.0, 10.0), BlockCrafting.ShapeBuilder.of(0.0, 10.0, 6.0, 15.0, 11.0, 10.0));
    public static final VoxelShape[] TOP_LEFT = BlockCrafting.joinedOrDirs(BlockCrafting.ShapeBuilder.of(1.0, 0.0, 6.5, 16.0, 15.0, 9.5), BlockCrafting.ShapeBuilder.of(0.0, 0.0, 6.0, 1.0, 16.0, 10.0), BlockCrafting.ShapeBuilder.of(1.0, 15.0, 6.0, 16.0, 16.0, 10.0));
    public static final VoxelShape[] TOP_RIGHT = BlockCrafting.joinedOrDirs(BlockCrafting.ShapeBuilder.of(0.0, 0.0, 6.5, 15.0, 15.0, 9.5), BlockCrafting.ShapeBuilder.of(15.0, 0.0, 6.0, 16.0, 16.0, 10.0), BlockCrafting.ShapeBuilder.of(0.0, 15.0, 6.0, 15.0, 16.0, 10.0));
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final double RANGE = 48.0;

    public BlockQuestboard(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Part)((Object)state.m_61143_(PART))) {
            default -> throw new IncompatibleClassChangeError();
            case Part.BOTTOM_LEFT -> BOTTOM_LEFT[((Direction)state.m_61143_((Property)BlockCrafting.f_54117_)).m_122416_()];
            case Part.BOTTOM_RIGHT -> BOTTOM_RIGHT[((Direction)state.m_61143_((Property)BlockCrafting.f_54117_)).m_122416_()];
            case Part.TOP_LEFT -> TOP_LEFT[((Direction)state.m_61143_((Property)BlockCrafting.f_54117_)).m_122416_()];
            case Part.TOP_RIGHT -> TOP_RIGHT[((Direction)state.m_61143_((Property)BlockCrafting.f_54117_)).m_122416_()];
        };
    }

    public BlockState m_7417_(BlockState state, Direction fromDir, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction normalizedFrom = BlockQuestboard.rotateBy(fromDir, dir);
        if (part.neighbors.contains(normalizedFrom) && (!fromState.m_60713_((Block)this) || fromState.m_61143_((Property)FACING) != dir || fromState.m_61143_(PART) != Part.getPartFor(part, normalizedFrom))) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, fromDir, fromState, level, pos, fromPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        QuestHandler.openGui(serverPlayer, Vec3.m_82512_((Vec3i)pos));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state;
        BlockPos blockpos = ctx.m_8083_();
        if (ctx.m_43725_().m_8055_(blockpos).m_60629_(ctx) && BlockQuestboard.getPosMap(blockpos, state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).stream().allMatch(p -> ctx.m_43725_().m_8055_((BlockPos)p.getSecond()).m_60629_(ctx))) {
            return state;
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        super.m_6402_(level, pos, state, living, stack);
        if (!level.f_46443_) {
            BlockQuestboard.getPosMap(pos, state).forEach(p -> level.m_7731_((BlockPos)p.getSecond(), (BlockState)state.m_61124_(PART, (Comparable)((Object)((Part)((Object)((Object)p.getFirst()))))), 3));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockQuestboard.getPosMap(pos, state).forEach(p -> {
                BlockState other = level.m_8055_((BlockPos)p.getSecond());
                if (other.m_60713_((Block)this) && other.m_61143_((Property)FACING) == facing && other.m_61143_(PART) == p.getFirst()) {
                    level.m_7731_((BlockPos)p.getSecond(), Blocks.f_50016_.m_49966_(), 3);
                    level.m_5898_(player, 2001, (BlockPos)p.getSecond(), Block.m_49956_((BlockState)other));
                }
            });
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    public static List<Pair<Part, BlockPos>> getPosMap(BlockPos from, BlockState state) {
        Rotation rotation = EntityUtils.fromDirection((Direction)state.m_61143_((Property)FACING));
        BlockPos offset = ((Part)((Object)state.m_61143_(BlockQuestboard.PART))).offset;
        return Arrays.stream(Part.values()).map(p -> Pair.of((Object)p, (Object)p.offset.m_142082_(-offset.m_123341_(), -offset.m_123342_(), -offset.m_123343_()).m_7954_(rotation).m_141952_((Vec3i)from))).toList();
    }

    private static Direction rotateBy(Direction direction, Direction rotate) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            return direction;
        }
        return switch (rotate) {
            case Direction.SOUTH -> direction.m_122424_();
            case Direction.EAST -> direction.m_122428_();
            case Direction.WEST -> direction.m_122427_();
            default -> direction;
        };
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_LEFT(BlockPos.f_121853_, List.of(Direction.UP, Direction.EAST)),
        BOTTOM_RIGHT(new BlockPos(1, 0, 0), List.of(Direction.UP, Direction.WEST)),
        TOP_LEFT(new BlockPos(0, 1, 0), List.of(Direction.DOWN, Direction.EAST)),
        TOP_RIGHT(new BlockPos(1, 1, 0), List.of(Direction.DOWN, Direction.WEST));

        public final BlockPos offset;
        public final List<Direction> neighbors;

        private Part(BlockPos offset, List<Direction> neighbors) {
            this.offset = offset;
            this.neighbors = neighbors;
        }

        @Nullable
        public static Part getPartFor(Part part, Direction direction) {
            BlockPos otherPos = part.offset.m_141952_(direction.m_122436_());
            for (Part p : Part.values()) {
                if (!p.offset.equals((Object)otherPos)) continue;
                return p;
            }
            return null;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

