/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.blocks.tile.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixinhelper.LevelSnapshotHandler;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class BlockTreeBase
extends RotatedPillarBlock
implements EntityBlock,
Growable {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private final Supplier<ConfiguredFeature<?, ?>> stump;
    private final Supplier<ConfiguredFeature<TreeConfiguration, ?>> tree1;
    private final Supplier<ConfiguredFeature<TreeConfiguration, ?>> tree2;
    private final Supplier<Item> seedItem;

    public BlockTreeBase(BlockBehaviour.Properties properties, Supplier<ConfiguredFeature<?, ?>> stump, Supplier<ConfiguredFeature<TreeConfiguration, ?>> tree1, Supplier<ConfiguredFeature<TreeConfiguration, ?>> tree2, Supplier<Item> seedItem) {
        super(properties);
        this.stump = stump;
        this.tree1 = tree1;
        this.tree2 = tree2;
        this.seedItem = seedItem;
    }

    public static boolean isAirOrReplaceable(BlockState state) {
        return state.m_60795_() || state.m_60767_() == Material.f_76302_ || state.m_204336_(BlockTags.f_13035_);
    }

    public boolean growTree(ServerLevel level, BlockPos pos, BlockState state, Random rand) {
        return switch ((Integer)state.m_61143_((Property)AGE)) {
            case 2 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                BlockEntity var6_5 = level.m_7702_(pos);
                if (var6_5 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_5;
                    tree.onRemove((Level)level, false);
                }
                boolean result = this.tree2.get().m_65385_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                yield result;
            }
            case 1 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                BlockEntity var6_6 = level.m_7702_(pos);
                if (var6_6 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_6;
                    tree.onRemove((Level)level, false);
                }
                boolean result = this.tree1.get().m_65385_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                yield result;
            }
            case 0 -> this.stump.get().m_65385_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, pos);
            default -> {
                BlockEntity var6_7 = level.m_7702_(pos);
                if (var6_7 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_7;
                    tree.update(level);
                }
                yield false;
            }
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!newState.m_60713_(state.m_60734_())) {
                FarmlandHandler.get(serverLevel.m_142572_()).getData(serverLevel, pos.m_7495_()).ifPresent(d -> d.onCropRemove(serverLevel, pos, newState));
                BlockEntity blockEntity = serverLevel.m_7702_(pos);
                if (blockEntity instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)blockEntity;
                    tree.onRemove(level, true);
                }
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TreeBlockEntity(pos, state);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.seedItem.get());
    }

    @Override
    public int runecraftory$getGrowableMaxAge() {
        return 4;
    }

    @Override
    public boolean canGrow(ServerLevel level, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)AGE) == 5) {
            return BlockPos.m_121990_((BlockPos)pos.m_142082_(-1, 0, -1), (BlockPos)pos.m_142082_(1, 2, 1)).allMatch(p -> p.equals((Object)pos) || BlockTreeBase.isAirOrReplaceable(level.m_8055_(p)));
        }
        return Growable.super.canGrow(level, pos, state);
    }

    @Override
    public BlockState runecraftory$getGrowableStateForAge(BlockState current, int age) {
        int newAge = current.m_61145_((Property)AGE).map(i -> Mth.m_14045_((int)(age - 1), (int)0, (int)(i + 1))).orElse(age - 1);
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge));
    }

    @Override
    public boolean runecraftory$isAtMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 4;
    }

    @Override
    public void onGrow(ServerLevel level, BlockPos pos, BlockState state, BlockState old) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (!old.m_60713_((Block)this) || !Objects.equals(old.m_61143_((Property)AGE), age) || this.runecraftory$isAtMaxAge(state)) {
            if (age == 0 || old.m_61145_((Property)AGE).orElse(0) == 2) {
                Growable.super.onGrow(level, pos, state, old);
            }
            if (this.growTree(level, pos, state, level.m_5822_())) {
                Growable.super.onGrow(level, pos, state, old);
                level.m_7731_(pos.m_7495_(), ((Block)ModBlocks.TREE_SOIL.get()).m_49966_(), 3);
            }
        }
    }
}

