/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.common.blocks.BlockTreeBase;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockTreeSapling
extends BushBlock
implements Growable {
    private final Supplier<BlockTreeBase> treeBase;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public BlockTreeSapling(BlockBehaviour.Properties properties, Supplier<BlockTreeBase> treeBase) {
        super(properties);
        this.treeBase = treeBase;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("runecraftory.tooltip.sapling").m_130940_(ChatFormatting.GRAY));
        super.m_5871_(stack, level, tooltip, flag);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return FarmlandHandler.isFarmBlock(state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FarmlandHandler.get(serverLevel.m_142572_()).getData(serverLevel, pos.m_7495_()).ifPresent(d -> d.onCropRemove(serverLevel, pos, newState));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public int runecraftory$getGrowableMaxAge() {
        return 4;
    }

    @Override
    public BlockState runecraftory$getGrowableStateForAge(BlockState current, int age) {
        if (age == 0) {
            return this.m_49966_();
        }
        return (BlockState)this.treeBase.get().m_49966_().m_61124_((Property)BlockTreeBase.AGE, (Comparable)Integer.valueOf(0));
    }

    @Override
    public boolean runecraftory$isAtMaxAge(BlockState state) {
        return false;
    }

    @Override
    public boolean canGrow(ServerLevel level, BlockPos pos, BlockState state) {
        return BlockPos.m_121990_((BlockPos)pos.m_142082_(-1, 0, -1), (BlockPos)pos.m_142082_(1, 2, 1)).allMatch(p -> p.equals((Object)pos) || BlockTreeBase.isAirOrReplaceable(level.m_8055_(p)));
    }
}

