/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.common.blocks.BlockBossSpawner;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BossSpawnerBlockEntity
extends BlockEntity {
    private int lastUpdateDay = -1;
    private int ticker;
    private ResourceLocation spawnListId;
    private StructureBossManager.BossSpawnList spawnList;
    private EntityType<?> nextSpawn;
    private ResourceLocation structureID;
    private StructureStart structure;
    private final Random random = new Random();

    public BossSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.BOSS_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BossSpawnerBlockEntity blockEntity) {
        ++blockEntity.ticker;
        if (blockEntity.ticker % 5 != 0) {
            return;
        }
        Vec3 pos = Vec3.m_82512_((Vec3i)blockPos.m_6630_(2));
        List<ServerPlayer> nearby = LevelCalc.playersAround((EntityGetter)level, pos, 20.0);
        if (!nearby.isEmpty() && blockEntity.nextSpawn != null) {
            boolean flag;
            EntityProperties prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(blockEntity.nextSpawn);
            boolean canSpawn = false;
            if (prop.spawnerPredicate != EntityPredicate.f_36550_) {
                ArrayList<ServerPlayer> removed = new ArrayList<ServerPlayer>();
                for (ServerPlayer player : nearby) {
                    if (!prop.spawnerPredicate.m_36611_(player, (Entity)player)) {
                        removed.add(player);
                        if (!player.m_20182_().m_82509_((Position)pos, 16.0)) continue;
                        Vec3 opposite = player.m_20182_().m_82546_(pos).m_82541_();
                        player.f_19789_ = 0.0f;
                        player.m_20256_(opposite);
                        player.m_9146_((Component)new TranslatableComponent("runecraftory.misc.spawner.entry.deny").m_130940_(ChatFormatting.DARK_PURPLE), ChatType.GAME_INFO, Util.f_137441_);
                        player.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        continue;
                    }
                    if (!player.m_20182_().m_82509_((Position)pos, 10.0)) continue;
                    canSpawn = true;
                }
                nearby.removeAll(removed);
            } else {
                canSpawn = true;
            }
            boolean bl = flag = blockEntity.lastUpdateDay != WorldUtils.day(level);
            if (canSpawn && flag) {
                blockEntity.spawnEntity(nearby, pos);
            }
        }
    }

    public StructureStart getStructure() {
        Level level;
        if (this.structureID != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.structure = serverLevel.m_8595_().m_207785_(this.m_58899_(), this.f_58857_.m_5962_().m_6632_(Registry.f_122882_).map(r -> (ConfiguredStructureFeature)r.m_7745_(this.structureID)).orElseThrow());
        }
        return this.structure;
    }

    public void spawnEntity(List<ServerPlayer> nearby, Vec3 pos) {
        Entity e;
        if (!this.f_58857_.f_46443_ && this.nextSpawn != null && (e = this.nextSpawn.m_20615_(this.f_58857_)) != null) {
            IBaseMob mob;
            this.lastUpdateDay = WorldUtils.day(this.f_58857_);
            if (e instanceof EnsembleMonsters) {
                EnsembleMonsters ensemble = (EnsembleMonsters)e;
                if (!ensemble.canSpawnerSpawn((ServerLevel)this.f_58857_, this.f_58858_, 32)) {
                    return;
                }
                ensemble.setLevel(LevelCalc.levelFromPos((ServerLevel)this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_), nearby));
                ensemble.setRestrictRadius(13);
                switch ((Direction)this.m_58900_().m_61143_((Property)BlockBossSpawner.FACING)) {
                    case SOUTH: {
                        ensemble.withDirection(Rotation.CLOCKWISE_180);
                        break;
                    }
                    case WEST: {
                        ensemble.withDirection(Rotation.COUNTERCLOCKWISE_90);
                        break;
                    }
                    case EAST: {
                        ensemble.withDirection(Rotation.CLOCKWISE_90);
                        break;
                    }
                    default: {
                        ensemble.withDirection(Rotation.NONE);
                        break;
                    }
                }
            } else if (!this.noNearby()) {
                return;
            }
            if (e instanceof IBaseMob) {
                mob = (IBaseMob)e;
                mob.setLevel(LevelCalc.levelFromPos((ServerLevel)this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_), nearby));
            }
            e.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 5), (double)this.f_58858_.m_123343_() + 0.5, this.f_58857_.f_46441_.nextFloat() * 360.0f, 0.0f);
            if (e instanceof Mob) {
                mob = (Mob)e;
                mob.m_21446_(this.f_58858_, 13);
                mob.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(e.m_142538_()), MobSpawnType.SPAWNER, null, null);
            }
            this.f_58857_.m_7967_(e);
            this.updateEntity();
        }
    }

    public void setEntity(EntityType<?> entity) {
        this.nextSpawn = entity;
    }

    private void updateEntity() {
        if (this.spawnList != null) {
            this.spawnList.getRandom(this.random).ifPresent(this::setEntity);
        }
    }

    private boolean noNearby() {
        return this.f_58857_.m_6443_(Mob.class, new AABB(this.f_58858_).m_82400_(32.0), e -> e.m_6095_() == this.nextSpawn || this.spawnList != null && this.spawnList.has(e.m_6095_())).isEmpty();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lastUpdateDay = tag.m_128451_("LastUpdate");
        if (tag.m_128441_("SpawnListId")) {
            this.spawnListId = new ResourceLocation(tag.m_128461_("SpawnListId"));
            this.spawnList = DataPackHandler.INSTANCE.structureBossManager().getBoss(new ResourceLocation(tag.m_128461_("SpawnListId")));
            this.updateEntity();
        }
        if (tag.m_128441_("Entity")) {
            this.nextSpawn = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(tag.m_128461_("Entity")));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("LastUpdate", this.lastUpdateDay);
        if (this.spawnListId != null) {
            tag.m_128359_("SpawnListId", this.spawnListId.toString());
        }
        if (this.nextSpawn != null) {
            tag.m_128359_("Entity", Registry.f_122826_.m_7981_(this.nextSpawn).toString());
        }
    }

    public static CompoundTag creatTagFor(ResourceLocation spawnListId) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("SpawnListId", spawnListId.toString());
        tag.m_128405_("LastUpdate", -1);
        return tag;
    }
}

