/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.api.IDailyUpdate;
import io.github.flemmli97.runecraftory.common.blocks.BlockBrokenMineral;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BrokenMineralBlockEntity
extends BlockEntity
implements IDailyUpdate {
    private int lastUpdateDay;
    private boolean check;

    public BrokenMineralBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.BROKEN_MINERAL_TILE.get(), blockPos, blockState);
    }

    @Override
    public void update(ServerLevel level) {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof BlockBrokenMineral) {
            BlockBrokenMineral mineral = (BlockBrokenMineral)block;
            this.f_58857_.m_46597_(this.f_58858_, mineral.getMineralState(state));
        }
    }

    @Override
    public boolean inValid() {
        return this.m_58901_();
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        Level level2 = this.f_58857_;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            WorldHandler.get(serverLevel.m_142572_()).addToTracker(this);
            int day = WorldUtils.day(this.f_58857_);
            if (this.check && this.lastUpdateDay != day) {
                this.f_58857_.m_142572_().m_6937_((Runnable)new TickTask(1, () -> this.update(serverLevel)));
            } else {
                this.lastUpdateDay = day;
                this.check = false;
                this.f_58857_.m_142572_().m_6937_((Runnable)new TickTask(1, () -> ((BrokenMineralBlockEntity)this).m_6596_()));
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lastUpdateDay = nbt.m_128451_("LastUpdate");
        this.check = true;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("LastUpdate", this.lastUpdateDay);
    }

    public void m_7651_() {
        super.m_7651_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WorldHandler.get(serverLevel.m_142572_()).removeFromTracker(this);
        }
    }
}

