/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.platform.SaveItemContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String DISPLAY_PREFIX = "runecraftory.container.crafting.";
    private final SaveItemContainer inventory;
    private final EnumCrafting type;
    private int craftingIndex;

    public CraftingBlockEntity(BlockEntityType<?> blockEntityType, EnumCrafting type, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.type = type;
        this.inventory = new SaveItemContainer(this, 6);
    }

    public Container getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return new TranslatableComponent(DISPLAY_PREFIX + this.type.getId());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.load(nbt.m_128469_("Inventory"));
        this.craftingIndex = nbt.m_128451_("Index");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.save());
        nbt.m_128405_("Index", this.craftingIndex);
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this.getInventory());
    }

    public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
        return new ContainerCrafting(windowID, inventory, this);
    }

    public int craftingIndex() {
        return this.craftingIndex;
    }

    public void setIndex(int craftingIndex) {
        this.craftingIndex = craftingIndex;
    }

    public void resetIndex() {
        this.craftingIndex = 0;
    }

    public EnumCrafting craftingType() {
        return this.type;
    }
}

