/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class MonsterBarnBlockEntity
extends BlockEntity {
    private static final int MAX_SIZE = 5;
    private UUID owner;
    private int cooldown = 0;
    private BarnData barnData;

    public MonsterBarnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.MONSTER_BARN_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MonsterBarnBlockEntity blockEntity) {
        BlockPos pos2;
        if (blockEntity.owner == null || --blockEntity.cooldown > 0 || !(level instanceof ServerLevel)) {
            return;
        }
        if (blockEntity.barnData == null) {
            blockEntity.barnData = WorldHandler.get(level.m_142572_()).getOrCreateFor(blockEntity.owner, level, blockPos);
        }
        blockEntity.cooldown = 40;
        int size = 5;
        for (BlockPos pos2 : BlockPos.m_121976_((int)(blockPos.m_123341_() - size), (int)(blockPos.m_123342_() - 1), (int)(blockPos.m_123343_() - size), (int)(blockPos.m_123341_() + size), (int)(blockPos.m_123342_() - 1), (int)(blockPos.m_123343_() + size))) {
            if (Math.abs(pos2.m_123341_() - blockPos.m_123341_()) > size || Math.abs(pos2.m_123343_() - blockPos.m_123343_()) > size || MonsterBarnBlockEntity.matches(level, pos2, true) || (size = Math.max(Math.abs(pos2.m_123341_() - blockPos.m_123341_()), Math.abs(pos2.m_123343_() - blockPos.m_123343_())) - 1) >= 2) continue;
            blockEntity.barnData.update(0, -1);
            return;
        }
        int airLayers = 10;
        pos2 = new BlockPos.MutableBlockPos();
        block1: for (int y = 0; y < airLayers; ++y) {
            for (int x = blockPos.m_123341_() - size; x < blockPos.m_123341_() + size; ++x) {
                for (int z = blockPos.m_123343_() - size; z < blockPos.m_123343_() + size; ++z) {
                    pos2.m_122178_(x, blockPos.m_123342_() + y, z);
                    if (pos2.equals((Object)blockPos) || MonsterBarnBlockEntity.matches(level, pos2, false)) continue;
                    airLayers = y;
                    break block1;
                }
            }
        }
        if (airLayers >= 3) {
            boolean hasRoof = true;
            for (BlockPos pos2 : BlockPos.m_121976_((int)(blockPos.m_123341_() - size), (int)(blockPos.m_123342_() + airLayers), (int)(blockPos.m_123343_() - size), (int)(blockPos.m_123341_() + size), (int)(blockPos.m_123342_() + airLayers), (int)(blockPos.m_123343_() + size))) {
                if (level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos2.m_123341_(), pos2.m_123343_()) > pos2.m_123342_()) continue;
                hasRoof = false;
                break;
            }
            blockEntity.barnData.update(size, hasRoof ? airLayers : -1);
        } else {
            blockEntity.barnData.update(0, -1);
        }
    }

    private static boolean matches(Level level, BlockPos pos, boolean ground) {
        BlockState state = level.m_8055_(pos);
        return ground ? state.m_204336_(RunecraftoryTags.BARN_GROUND) : !state.m_60713_((Block)ModBlocks.MONSTER_BARN.get()) && state.m_60812_((BlockGetter)level, pos).m_83281_();
    }

    @Nullable
    public BarnData getBarnData() {
        return this.barnData;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID uuid) {
        this.owner = uuid;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128403_("Owner")) {
            this.owner = nbt.m_128342_("Owner");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
        return nbt;
    }
}

