/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SingleTimeSpawner
extends BlockEntity {
    private EntityType<?> savedEntity;
    private ResourceLocation shop;
    private CompoundTag tag;
    private int delay = 3;

    public SingleTimeSpawner(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.SINGLE_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SingleTimeSpawner blockEntity) {
        if (--blockEntity.delay > 0) {
            return;
        }
        if (blockEntity.savedEntity != null) {
            blockEntity.spawnEntity();
        }
        level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
    }

    private void spawnEntity() {
        Entity e;
        if (!this.f_58857_.f_46443_ && (e = this.savedEntity.m_20615_(this.f_58857_)) != null) {
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                mob.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(e.m_142538_()), MobSpawnType.SPAWNER, null, null);
            }
            if (e instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)e;
                npc.randomizeData(this.shop);
            }
            e.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, this.f_58857_.f_46441_.nextFloat() * 360.0f, 0.0f);
            if (this.tag != null) {
                CompoundTag newTag = e.m_20240_(new CompoundTag());
                newTag.m_128391_(this.tag);
                e.m_20258_(newTag);
            }
            this.f_58857_.m_7967_(e);
        }
    }

    public void setEntity(ResourceLocation entity, CompoundTag tag) {
        this.savedEntity = (EntityType)Registry.f_122826_.m_7745_(entity);
        this.tag = tag;
        if (this.tag != null && this.tag.m_128403_("UUID")) {
            this.tag.m_128473_("UUID");
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.savedEntity = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(nbt.m_128461_("Entity")));
        if (nbt.m_128441_("EntityNBT")) {
            this.tag = nbt.m_128469_("EntityNBT");
        }
        if (nbt.m_128441_("NPCShop")) {
            this.shop = new ResourceLocation(nbt.m_128461_("NPCShop"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.savedEntity != null) {
            nbt.m_128359_("Entity", Registry.f_122826_.m_7981_(this.savedEntity).toString());
        }
        if (this.tag != null) {
            nbt.m_128365_("EntityNBT", (Tag)this.tag);
        }
        if (this.shop != null) {
            nbt.m_128359_("NPCShop", this.shop.toString());
        }
    }
}

