/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.BlockFruitTreeLeaf;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.Logger;

public class TreeBlockEntity
extends BlockEntity {
    private static final int MAX_HEALTH = 50;
    private int health;
    private List<BlockPos> logs = new ArrayList<BlockPos>();
    private List<BlockPos> leaves = new ArrayList<BlockPos>();
    private List<BlockPos> fruits = new ArrayList<BlockPos>();

    public TreeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.TREE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void updateTreeLogs(Collection<BlockPos> pos) {
        this.logs = new ArrayList<BlockPos>(pos.stream().filter(p -> !p.equals((Object)this.m_58899_().m_7495_())).toList());
        this.m_6596_();
    }

    public void updateTreeLeaves(Collection<BlockPos> pos) {
        this.leaves = new ArrayList<BlockPos>(pos);
        this.m_6596_();
    }

    public void updateTreeFruits(Collection<BlockPos> pos) {
        this.fruits = new ArrayList<BlockPos>(pos);
        this.m_6596_();
    }

    public int getHealth() {
        return this.health;
    }

    public void onBreak() {
        this.health = Math.max(0, this.health - 5);
    }

    public void dailyUpdate() {
        this.health = Math.min(50, this.health + 3);
    }

    public void update(ServerLevel level) {
        for (BlockPos pos : this.fruits) {
            BlockState state = level.m_8055_(pos);
            if (!(state.m_60734_() instanceof BlockFruitTreeLeaf)) continue;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.health = tag.m_128451_("Health");
        ListTag logs = tag.m_128437_("Logs", 11);
        logs.forEach(t -> this.logs.add((BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
        ListTag leaves = tag.m_128437_("Leaves", 11);
        leaves.forEach(t -> this.leaves.add((BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
        ListTag fruits = tag.m_128437_("Fruits", 11);
        fruits.forEach(t -> this.fruits.add((BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Health", this.health);
        ListTag logs = new ListTag();
        this.logs.forEach(p -> logs.add((Object)((Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.m_128365_("Logs", (Tag)logs);
        ListTag leaves = new ListTag();
        this.leaves.forEach(p -> leaves.add((Object)((Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.m_128365_("Leaves", (Tag)leaves);
        ListTag fruits = new ListTag();
        this.fruits.forEach(p -> fruits.add((Object)((Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.m_128365_("Fruits", (Tag)fruits);
    }

    public void onRemove(Level level, boolean particle) {
        this.logs.forEach(p -> this.removeBlock(level, (BlockPos)p, particle));
        this.leaves.forEach(p -> this.removeBlock(level, (BlockPos)p, particle));
        this.fruits.forEach(p -> this.removeBlock(level, (BlockPos)p, particle));
    }

    private void removeBlock(Level level, BlockPos pos, boolean particle) {
        BlockState blockState = level.m_8055_(pos);
        if (particle) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
        }
        level.m_7731_(pos, blockState.m_60819_().m_76188_(), 2);
    }
}

