/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.commands.SpellArgumentType;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class RunecraftoryCommand {
    public static void reg(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"runecraftory").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"skill", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(Stream.concat(Stream.of(EnumSkills.values()).map(Object::toString), Stream.of("ALL")), (SuggestionsBuilder)builder)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillLevel)))).then(Commands.m_82127_((String)"xp").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillXP))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setSkillLevel))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"level").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setLevel)))).then(Commands.m_82127_((String)"xp").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addLevelXP)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlockRecipes").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"all").executes(RunecraftoryCommand::unlockRecipes))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(RunecraftoryCommand::allRecipes).executes(RunecraftoryCommand::unlockRecipe)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"recalcStats").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(RunecraftoryCommand::recalcStats)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"weather").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"weather", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(Stream.of(EnumWeather.values()).map(Object::toString), (SuggestionsBuilder)builder)).executes(RunecraftoryCommand::setWeather)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"all").executes(RunecraftoryCommand::resetAll))).then(Commands.m_82127_((String)"recipes").executes(RunecraftoryCommand::resetRecipes))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spell").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"cast").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<CommandSourceStack>)ctx, Set.of(((CommandSourceStack)ctx.getSource()).m_81374_())))).then(Commands.m_82129_((String)"for", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"as"))))))).then(Commands.m_82127_((String)"apply").then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgumentType.spell()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<CommandSourceStack>)ctx, Set.of(((CommandSourceStack)ctx.getSource()).m_81374_())))).then(Commands.m_82129_((String)"for", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"as")))))))));
    }

    private static int addSkillLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        LevelExpPair skLvl = data.getSkillLevel(skill);
                        data.setSkillLevel(skill, (Player)player, skLvl.getLevel() + amount, skLvl.getXp(), true);
                    }
                });
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.lvl.add", new Object[]{s, player.m_7755_(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                LevelExpPair skLvl = data.getSkillLevel(skill);
                data.setSkillLevel(skill, (Player)player, skLvl.getLevel() + amount, skLvl.getXp(), true);
            });
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.lvl.add", new Object[]{s, player.m_7755_(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addSkillXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        data.increaseSkill(skill, (Player)player, amount);
                    }
                });
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.lvl.add", new Object[]{s, player.m_7755_(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.increaseSkill(skill, (Player)player, amount));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.xp.add", new Object[]{s, player.m_7755_(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setSkillLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        data.setSkillLevel(skill, (Player)player, amount, 0.0f, true);
                    }
                });
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.lvl.set", new Object[]{s, player.m_7755_(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.setSkillLevel(skill, (Player)player, amount, 0.0f, true));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.skill.lvl.set", new Object[]{new TranslatableComponent(skill.getTranslation()), player.m_7755_(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addLevelXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.addXp((Player)player, amount));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.lvl.xp.add", new Object[]{player.m_7755_(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.setPlayerLevel((Player)player, amount, 0.0f, true));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.lvl.set", new Object[]{player.m_7755_(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetAll(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                data.resetAll(player);
                Platform.INSTANCE.sendToClient(new S2CCapSync((PlayerData)data), player);
            });
            QuestHandler.getData(player).resetAll();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.reset.all", new Object[]{player.m_7755_()}), false);
            ++ret;
        }
        return ret;
    }

    private static CompletableFuture<Suggestions> allRecipes(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)((CommandSourceStack)ctx.getSource()).m_81375_()).orElse(null);
        if (data != null) {
            for (SextupleRecipe r : ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.FORGE.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.m_6423_());
            }
            for (SextupleRecipe r : ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.CHEMISTRY.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.m_6423_());
            }
            for (SextupleRecipe r : ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.ARMOR.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.m_6423_());
            }
            for (SextupleRecipe r : ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.COOKING.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.m_6423_());
            }
        }
        return SharedSuggestionProvider.m_82981_(allRecipes.stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    }

    private static int unlockRecipe(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation res = ResourceLocationArgument.m_107011_(ctx, (String)"id");
        int ret = 0;
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getRecipeKeeper().unlockRecipesRes((Player)player, List.of(res)));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.unlock.recipe", new Object[]{player.m_7755_(), res.toString()}), false);
            ++ret;
        }
        return ret;
    }

    private static int unlockRecipes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.FORGE.get()).forEach(r -> allRecipes.add(r.m_6423_()));
        ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.CHEMISTRY.get()).forEach(r -> allRecipes.add(r.m_6423_()));
        ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.ARMOR.get()).forEach(r -> allRecipes.add(r.m_6423_()));
        ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44013_((RecipeType)ModCrafting.COOKING.get()).forEach(r -> allRecipes.add(r.m_6423_()));
        int ret = 0;
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getRecipeKeeper().unlockRecipesRes((Player)player, allRecipes));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.unlock.recipes", new Object[]{player.m_7755_()}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetRecipes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getRecipeKeeper().lockRecipesRes((Player)player, data.getRecipeKeeper().unlockedRecipes()));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.reset.recipe", new Object[]{player.m_7755_()}), false);
            ++ret;
        }
        return ret;
    }

    private static int setWeather(CommandContext<CommandSourceStack> ctx) {
        EnumWeather weather;
        String s = StringArgumentType.getString(ctx, (String)"weather");
        try {
            weather = EnumWeather.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TranslatableComponent("runecraftory.command.weather.no", new Object[]{s}));
            return 0;
        }
        WorldHandler.get(((CommandSourceStack)ctx.getSource()).m_81377_()).updateWeatherTo(((CommandSourceStack)ctx.getSource()).m_81372_(), weather);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.set.weather", new Object[]{new TranslatableComponent(weather.translation)}), false);
        return 1;
    }

    private static int recalcStats(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection entities = EntityArgument.m_91461_(ctx, (String)"entities");
        int i = 0;
        for (Entity e : entities) {
            if (e instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> d.recalculateStats(player, false));
                ++i;
                continue;
            }
            if (e instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)e;
                npc.recalcStatsFull();
                ++i;
                continue;
            }
            if (!(e instanceof BaseMonster)) continue;
            BaseMonster monster = (BaseMonster)e;
            monster.recalcStatsFull();
            ++i;
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("runecraftory.command.recalc.stats", new Object[]{i}), false);
        return i;
    }

    private static int castSpell(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) {
        int success = 0;
        Spell spell = SpellArgumentType.getSpell(ctx, "spell");
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            spell.use(living);
            ++success;
        }
        return success;
    }

    private static int applySpellTo(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) {
        int success = 0;
        Spell spell = SpellArgumentType.getSpell(ctx, "spell");
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        for (Entity entity : entities) {
            LivingEntity living;
            ItemStack stack;
            if (!(entity instanceof LivingEntity) || !((stack = (living = (LivingEntity)entity).m_21205_()).m_41720_() instanceof ItemStaffBase)) continue;
            Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                switch (tier) {
                    case 3: {
                        data.setTier3Spell(spell);
                        break;
                    }
                    case 2: {
                        data.setTier2Spell(spell);
                        break;
                    }
                    default: {
                        data.setTier1Spell(spell);
                    }
                }
            });
            ++success;
        }
        return success;
    }
}

