/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;

public class LevelUpUpgradeRecipe
extends UpgradeRecipe {
    private final ResourceLocation id;
    protected final int level;
    protected final Ingredient base;
    protected final Ingredient upgradeMaterial;

    public LevelUpUpgradeRecipe(ResourceLocation id, int level, Ingredient base, Ingredient upgradeMaterial) {
        super(id, base, upgradeMaterial, ItemStack.f_41583_);
        this.id = id;
        this.level = level;
        this.base = base;
        this.upgradeMaterial = upgradeMaterial;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5818_(Container container, Level level) {
        ItemStack stack = container.m_8020_(0);
        if (ItemNBT.itemLevel(stack) != this.level) {
            return false;
        }
        return super.m_5818_(container, level);
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ItemStack m_5874_(Container container) {
        ItemStack stack = container.m_8020_(0).m_41777_();
        ItemNBT.getLeveledItem(stack, ItemNBT.itemLevel(stack) + 1);
        return stack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModCrafting.LEVEL_UPGRADE_SERIALIZER.get();
    }

    public static class Serializer
    extends CustomRegistryEntry<Serializer>
    implements RecipeSerializer<LevelUpUpgradeRecipe> {
        public LevelUpUpgradeRecipe fromJson(ResourceLocation id, JsonObject json) {
            int level = GsonHelper.m_13927_((JsonObject)json, (String)"current_level");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"material"));
            return new LevelUpUpgradeRecipe(id, level, ingredient, ingredient1);
        }

        public LevelUpUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int level = buffer.readInt();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new LevelUpUpgradeRecipe(recipeId, level, ingredient, ingredient1);
        }

        public void toNetwork(FriendlyByteBuf buffer, LevelUpUpgradeRecipe recipe) {
            buffer.writeInt(recipe.level);
            recipe.base.m_43923_(buffer);
            recipe.upgradeMaterial.m_43923_(buffer);
        }
    }
}

