/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RecipeBuilder {
    private final ItemStack result;
    private final int level;
    private final int addCost;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final RecipeSerializer<?> serializer;
    private final EnumCrafting type;
    private String group;

    private RecipeBuilder(EnumCrafting type, ItemStack item, int level, int addCost, RecipeSerializer<?> serializer) {
        this.type = type;
        this.result = item;
        this.level = level;
        this.addCost = addCost;
        this.serializer = serializer;
    }

    public static RecipeBuilder create(EnumCrafting type, ItemLike item, int level) {
        return RecipeBuilder.create(type, item, 1, level);
    }

    public static RecipeBuilder create(EnumCrafting type, ItemLike item, int count, int level) {
        return RecipeBuilder.create(type, new ItemStack(item, count), level, 1);
    }

    public static RecipeBuilder create(EnumCrafting type, ItemLike item, int count, int level, int addCost) {
        return RecipeBuilder.create(type, new ItemStack(item, count), level, addCost);
    }

    public static RecipeBuilder create(EnumCrafting type, ItemStack item, int level, int addCost) {
        RecipeSerializer serializer = switch (type) {
            case EnumCrafting.FORGE -> (RecipeSerializer)ModCrafting.FORGING_SERIALIZER.get();
            case EnumCrafting.ARMOR -> (RecipeSerializer)ModCrafting.ARMOR_SERIALIZER.get();
            case EnumCrafting.CHEM -> (RecipeSerializer)ModCrafting.CHEMISTRY_SERIALIZER.get();
            default -> (RecipeSerializer)ModCrafting.COOKING_SERIALIZER.get();
        };
        return new RecipeBuilder(type, item, level, addCost, serializer);
    }

    public RecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public RecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public RecipeBuilder addIngredient(ItemLike item, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public RecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public RecipeBuilder addIngredient(Ingredient ingredient, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public RecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> cons) {
        this.build(cons, Registry.f_122827_.m_7981_((Object)this.result.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> cons, String string) {
        this.build(cons, new ResourceLocation(string));
    }

    public void build(Consumer<FinishedRecipe> cons, ResourceLocation res) {
        this.validate(res);
        cons.accept(new Result(new ResourceLocation(res.m_135827_(), this.type.getId() + "/" + res.m_135815_()), this.result, this.level, this.addCost, this.group == null ? "" : this.group, this.ingredients){

            @Override
            public RecipeSerializer<?> m_6637_() {
                return RecipeBuilder.this.serializer;
            }
        });
    }

    private void validate(ResourceLocation res) {
        if (this.ingredients.size() > 6) {
            throw new IllegalStateException("Recipe " + String.valueOf(res) + " too big. Max size is 6");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final int level;
        private final int cost;
        private final String group;
        private final List<Ingredient> ingredients;

        public Result(ResourceLocation res, ItemStack output, int level, int cost, String group, List<Ingredient> ingredients) {
            this.id = res;
            this.result = output;
            this.level = level;
            this.cost = cost;
            this.group = group;
            this.ingredients = ingredients;
        }

        public void m_7917_(JsonObject obj) {
            if (!this.group.isEmpty()) {
                obj.addProperty("group", this.group);
            }
            obj.addProperty("level", (Number)this.level);
            obj.addProperty("additional_cost", (Number)this.cost);
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            obj.add("ingredients", (JsonElement)jsonarray);
            obj.add("result", this.itemStackToJson(this.result));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }

        private JsonElement itemStackToJson(ItemStack stack) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                obj.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                CompoundTag.f_128325_.encode((Object)stack.m_41783_(), (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().ifPresent(e -> obj.add("nbt", e));
            }
            return obj;
        }
    }
}

