/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class SextupleRecipe
implements Recipe<PlayerContainerInv> {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final int craftingLevel;
    private final int baseCost;

    public SextupleRecipe(ResourceLocation id, String group, int level, int baseCost, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.group = group;
        this.recipeOutput = result;
        this.recipeItems = ingredients;
        this.craftingLevel = level;
        this.baseCost = baseCost;
    }

    public boolean matches(PlayerContainerInv inv, Level world) {
        return this.checkMatch(inv, world, false);
    }

    public boolean checkMatch(PlayerContainerInv inv, Level world, boolean exact) {
        if (inv.m_6643_() < 6) {
            return false;
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).map(cap -> cap.getRecipeKeeper().isUnlockedForCrafting(this)).orElse(false);
        if (!unlocked) {
            return false;
        }
        NonNullList stacks = NonNullList.m_122779_();
        for (int j = 0; j < 6; ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            stacks.add((Object)itemStack);
        }
        Pair<NonNullList<ItemStack>, NonNullList<ItemStack>> result = SextupleRecipe.matchingStacks(this, (NonNullList<ItemStack>)stacks);
        int matches = ((NonNullList)result.getFirst()).size();
        if (matches != this.m_7527_().size()) {
            return false;
        }
        return !exact || ((NonNullList)result.getSecond()).isEmpty();
    }

    public ItemStack assemble(PlayerContainerInv inv) {
        return this.getCraftingOutput(inv).serverResult();
    }

    public RecipeOutput getCraftingOutput(PlayerContainerInv inv) {
        if (inv.m_6643_() < 6) {
            return new RecipeOutput(ItemStack.f_41583_, ItemStack.f_41583_, (NonNullList<ItemStack>)NonNullList.m_122779_());
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).map(cap -> cap.getRecipeKeeper().isUnlocked(this)).orElse(false);
        NonNullList stacks = NonNullList.m_122779_();
        for (int j = 0; j < 6; ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            stacks.add((Object)itemStack);
        }
        Pair<NonNullList<ItemStack>, NonNullList<ItemStack>> ing = SextupleRecipe.matchingStacks(this, (NonNullList<ItemStack>)stacks);
        EnumCrafting type = EnumCrafting.FORGE;
        if (this.m_6671_() == ModCrafting.ARMOR.get()) {
            type = EnumCrafting.ARMOR;
        }
        if (this.m_6671_() == ModCrafting.CHEMISTRY.get()) {
            type = EnumCrafting.CHEM;
        }
        if (this.m_6671_() == ModCrafting.COOKING.get()) {
            type = EnumCrafting.COOKING;
        }
        ItemStack trueOutput = CraftingUtils.getCraftingOutput(this.recipeOutput.m_41777_(), inv, ing, type);
        return new RecipeOutput(trueOutput, unlocked ? trueOutput : new ItemStack((ItemLike)ModItems.UNKNOWN.get()), (NonNullList<ItemStack>)((NonNullList)ing.getSecond()));
    }

    public static Pair<NonNullList<ItemStack>, NonNullList<ItemStack>> matchingStacks(SextupleRecipe recipe, NonNullList<ItemStack> inv) {
        if (inv.size() > 6) {
            return Pair.of((Object)NonNullList.m_122779_(), (Object)NonNullList.m_122779_());
        }
        for (ItemStack s : inv) {
            if (recipe.areItemsFitting(s)) continue;
            return Pair.of((Object)NonNullList.m_122779_(), (Object)NonNullList.m_122779_());
        }
        NonNullList list = NonNullList.m_122779_();
        NonNullList bonus = NonNullList.m_122779_();
        block1: for (Ingredient ing : recipe.m_7527_()) {
            for (ItemStack stack : inv) {
                if (!ing.test(stack) || list.contains((Object)stack)) continue;
                list.add((Object)stack);
                continue block1;
            }
        }
        for (ItemStack stack : inv) {
            if (list.contains((Object)stack)) continue;
            bonus.add((Object)stack);
        }
        return Pair.of((Object)list, (Object)bonus);
    }

    public boolean areItemsFitting(ItemStack stack) {
        return true;
    }

    public boolean m_8004_(int x, int y) {
        return x * y > this.recipeItems.size();
    }

    public ItemStack m_8043_() {
        return this.recipeOutput.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public String m_6076_() {
        return this.group;
    }

    public abstract ItemStack m_8042_();

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public abstract RecipeSerializer<?> m_7707_();

    public abstract RecipeType<?> m_6671_();

    public int getCraftingLevel() {
        return this.craftingLevel;
    }

    public int getAdditionalCost() {
        return this.baseCost;
    }

    public String toString() {
        return String.format("Result: %s; Required Level: %d; ID: %s", this.recipeOutput, this.craftingLevel, this.id);
    }

    public record RecipeOutput(ItemStack serverResult, ItemStack clientResult, NonNullList<ItemStack> bonusItems) {
    }

    public static abstract class Serializer<T extends SextupleRecipe>
    extends CustomRegistryEntry<Serializer<T>>
    implements RecipeSerializer<T> {
        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public T fromJson(ResourceLocation res, JsonObject obj) {
            String s = GsonHelper.m_13851_((JsonObject)obj, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)obj, (String)"ingredients"));
            int level = GsonHelper.m_13824_((JsonObject)obj, (String)"level", (int)1);
            int baseCost = GsonHelper.m_13824_((JsonObject)obj, (String)"additional_cost", (int)1);
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 6) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 6");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)obj, (String)"result"));
            return this.get(res, s, level, baseCost, itemstack, nonnulllist);
        }

        public T fromNetwork(ResourceLocation res, FriendlyByteBuf buffer) {
            int level = buffer.readInt();
            int cost = buffer.readInt();
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            nonnulllist.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemstack = buffer.m_130267_();
            return this.get(res, s, level, cost, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.writeInt(((SextupleRecipe)recipe).getCraftingLevel());
            buffer.writeInt(((SextupleRecipe)recipe).getAdditionalCost());
            buffer.m_130070_(((SextupleRecipe)recipe).m_6076_());
            buffer.m_130130_(((SextupleRecipe)recipe).m_7527_().size());
            for (Ingredient ingredient : ((SextupleRecipe)recipe).m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(((SextupleRecipe)recipe).m_8043_());
        }

        public abstract T get(ResourceLocation var1, String var2, int var3, int var4, ItemStack var5, NonNullList<Ingredient> var6);
    }
}

