/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.utils.MiscUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FoodManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "food_stats";
    private Map<Item, FoodProperties> food = ImmutableMap.of();
    private boolean resolved;
    private Map<TagKey<Item>, FoodProperties> tagFood = ImmutableMap.of();

    public FoodManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    @Nullable
    public FoodProperties get(Item item) {
        if (GeneralConfig.disableFoodSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.food.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap<Item, FoodProperties> itemEntries = new HashMap<Item, FoodProperties>(this.food);
            this.tagFood.entrySet().stream().sorted(Comparator.comparing(e -> ((TagKey)e.getKey()).f_203868_())).forEach(entry -> MiscUtils.expandTag(Registry.f_122827_, (TagKey)entry.getKey()).forEach(item -> {
                if (!itemEntries.containsKey(item)) {
                    itemEntries.put((Item)item, (FoodProperties)entry.getValue());
                }
            }));
            this.food = ImmutableMap.copyOf(itemEntries);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.resolved = false;
        ImmutableMap.Builder itemEntries = ImmutableMap.builder();
        ImmutableMap.Builder tagEntries = ImmutableMap.builder();
        data.forEach((fres, el) -> {
            try {
                JsonObject obj = el.getAsJsonObject();
                String key = GsonHelper.m_13906_((JsonObject)obj, (String)"item");
                if (key.startsWith("#")) {
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(key.substring(1)));
                    FoodProperties props = (FoodProperties)FoodProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                    props.setID((ResourceLocation)fres);
                    tagEntries.put((Object)tag, (Object)props);
                } else {
                    Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(key));
                    if (item != Items.f_41852_) {
                        FoodProperties props = (FoodProperties)FoodProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                        props.setID((ResourceLocation)fres);
                        itemEntries.put((Object)item, (Object)props);
                    }
                }
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldn't parse food stat json {} {}", fres, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.food = itemEntries.build();
        this.tagFood = tagEntries.build();
    }

    public void toPacket(FriendlyByteBuf buffer) {
        this.resolveTags(false);
        buffer.writeInt(this.food.size());
        this.food.forEach((item, prop) -> {
            buffer.m_130085_(Registry.f_122827_.m_7981_(item));
            prop.toPacket(buffer);
        });
    }

    public void fromPacket(FriendlyByteBuf buffer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)((Item)Registry.f_122827_.m_7745_(buffer.m_130281_())), (Object)FoodProperties.fromPacket(buffer));
        }
        this.food = builder.build();
    }
}

