/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GateSpawnData;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.apache.logging.log4j.Logger;

public class GateSpawnsManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "gate_spawning";
    private Map<TagKey<Biome>, List<SpawnResource>> biomeSpawns = new HashMap<TagKey<Biome>, List<SpawnResource>>();
    private Map<ConfiguredStructureFeature<?, ?>, List<SpawnResource>> structureSpawns = new HashMap();

    public GateSpawnsManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public List<EntityType<?>> pickRandomMobs(ServerLevel level, GateEntity gate, Holder<Biome> biome, Random rand, int amount, BlockPos pos, List<ServerPlayer> players) {
        List<SpawnResource> list = level.m_8595_().m_207811_(SectionPos.m_123199_((BlockPos)pos), this.structureSpawns::containsKey).stream().filter(start -> start.m_73601_().m_71051_((Vec3i)pos)).map(start -> this.structureSpawns.get(start.m_210081_())).flatMap(Collection::stream).collect(Collectors.toList());
        if (list.isEmpty()) {
            biome.m_203616_().forEach(tag -> {
                List<SpawnResource> l = this.biomeSpawns.get(tag);
                if (l != null) {
                    list.addAll(l);
                }
            });
        }
        list.removeIf(w -> w.playerPredicate != EntityPredicate.f_36550_ && players.stream().noneMatch(p -> w.playerPredicate.m_36611_(p, (Entity)p)));
        if (list.isEmpty()) {
            return new ArrayList();
        }
        double dist = pos.m_123331_((Vec3i)level.m_8900_());
        BlockState state = level.m_8055_(pos);
        list.removeIf(w -> !w.matches(level, pos, state, dist, gate));
        ArrayList ret = new ArrayList();
        if (amount > list.size()) {
            list.forEach(w -> ret.add(w.entity));
        } else {
            EntityType type;
            int totalWeight = WeightedRandom.m_146312_(list);
            for (int i = amount; i > 0 && !ret.contains(type = (EntityType)WeightedRandom.m_146320_((Random)rand, list, (int)totalWeight).map(w -> w.entity).orElse(null)); --i) {
                if (type == null) continue;
                ret.add(type);
            }
        }
        return ret;
    }

    public boolean hasSpawns(ServerLevelAccessor level, BlockPos pos, BlockState state) {
        if (level.m_204166_(pos).m_203616_().anyMatch(t -> {
            List<SpawnResource> l = this.biomeSpawns.get(t);
            return l != null && l.stream().anyMatch(r -> r.canSpawn(level.m_6018_(), pos, state));
        })) {
            return true;
        }
        return this.hasStructureSpawns(level.m_6018_(), pos);
    }

    public boolean hasStructureSpawns(ServerLevel world, BlockPos pos) {
        return world.m_8595_().m_207811_(SectionPos.m_123199_((BlockPos)pos), this.structureSpawns::containsKey).stream().anyMatch(start -> start.m_73601_().m_71051_((Vec3i)pos));
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        LinkedHashMap biomeSpawns = new LinkedHashMap();
        LinkedHashMap structureSpawns = new LinkedHashMap();
        data.forEach((fres, el) -> {
            try {
                GateSpawnData spawnData = (GateSpawnData)GateSpawnData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                Optional optType = Registry.f_122826_.m_6612_(spawnData.entity());
                optType.ifPresentOrElse(type -> {
                    spawnData.biomes().forEach((key, weight) -> {
                        SpawnResource resource = new SpawnResource((EntityType<?>)type, spawnData, (int)weight);
                        biomeSpawns.computeIfAbsent(key, o -> new ArrayList()).add(resource);
                    });
                    spawnData.structures().forEach((key, weight) -> {
                        Optional optFeat = BuiltinRegistries.f_123862_.m_6612_(key);
                        optFeat.ifPresentOrElse(feat -> {
                            SpawnResource resource = new SpawnResource((EntityType<?>)type, spawnData, (int)weight);
                            structureSpawns.computeIfAbsent(feat, o -> new ArrayList()).add(resource);
                        }, () -> RuneCraftory.LOGGER.error("No such feature {} for spawn data {}", key, fres));
                    });
                }, () -> RuneCraftory.LOGGER.error("No such entity {} for spawn data {}", (Object)spawnData.entity(), fres));
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldnt parse spawn data json {} {}", fres, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.biomeSpawns = ImmutableMap.copyOf(biomeSpawns);
        this.structureSpawns = ImmutableMap.copyOf(structureSpawns);
    }

    public static class SpawnResource
    extends WeightedEntry.IntrusiveBase {
        private final EntityType<?> entity;
        private final int distToSpawnSq;
        private final int minGateLevel;
        private final boolean allowWater;
        private final EntityPredicate gatePredicate;
        private final EntityPredicate playerPredicate;

        public SpawnResource(EntityType<?> entity, GateSpawnData spawnData, int weight) {
            super(weight);
            this.entity = entity;
            this.distToSpawnSq = spawnData.minDistanceFromSpawn() * spawnData.minDistanceFromSpawn();
            this.minGateLevel = spawnData.minGateLevel();
            this.allowWater = spawnData.canSpawnInWater();
            this.gatePredicate = spawnData.gatePredicate();
            this.playerPredicate = spawnData.playerPredicate();
        }

        public boolean canSpawn(ServerLevel serverLevel, BlockPos pos, BlockState state) {
            return pos.m_123331_((Vec3i)serverLevel.m_8900_()) >= (double)this.distToSpawnSq && (state.m_60819_().m_76178_() || this.allowWater && state.m_60819_().m_205070_(FluidTags.f_13131_) && serverLevel.m_46861_(pos));
        }

        public boolean matches(ServerLevel serverLevel, BlockPos pos, BlockState state, double dist, GateEntity gate) {
            return dist >= (double)this.distToSpawnSq && (state.m_60819_().m_76178_() || this.allowWater && state.m_60819_().m_205070_(FluidTags.f_13131_) && serverLevel.m_46861_(pos)) && gate.level().getLevel() >= this.minGateLevel && this.gatePredicate.m_36607_(serverLevel, gate.m_20182_(), (Entity)gate);
        }

        public String toString() {
            return String.format("Entity: %s, MinSpawnSq: %d, Weight: %s, MinGateLevel: %s", Registry.f_122826_.m_7981_(this.entity), this.distToSpawnSq, this.m_142631_(), this.minGateLevel);
        }
    }
}

