/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;

public class ItemCraftingLevelManager {
    private static Map<Item, Pair<Integer, EnumSkills>> craftingLevelCache;

    public static void reload(MinecraftServer server) {
        craftingLevelCache = new HashMap<Item, Pair<Integer, EnumSkills>>();
        ItemCraftingLevelManager.add(server.m_129894_().m_44013_((RecipeType)ModCrafting.FORGE.get()), EnumSkills.FORGING);
        ItemCraftingLevelManager.add(server.m_129894_().m_44013_((RecipeType)ModCrafting.CHEMISTRY.get()), EnumSkills.CHEMISTRY);
        ItemCraftingLevelManager.add(server.m_129894_().m_44013_((RecipeType)ModCrafting.ARMOR.get()), EnumSkills.CRAFTING);
        ItemCraftingLevelManager.add(server.m_129894_().m_44013_((RecipeType)ModCrafting.COOKING.get()), EnumSkills.COOKING);
    }

    private static void add(Collection<SextupleRecipe> recipes, EnumSkills skills) {
        for (SextupleRecipe recipe : recipes) {
            craftingLevelCache.compute(recipe.m_8043_().m_41720_(), (item, old) -> {
                if (old != null && (Integer)old.getFirst() <= recipe.getCraftingLevel()) {
                    return old;
                }
                return Pair.of((Object)recipe.getCraftingLevel(), (Object)((Object)skills));
            });
        }
    }

    public static Pair<Integer, EnumSkills> getLowestLevel(MinecraftServer server, Item item) {
        if (craftingLevelCache == null) {
            ItemCraftingLevelManager.reload(server);
        }
        return craftingLevelCache.get(item);
    }

    public static void reset() {
        craftingLevelCache = null;
    }
}

