/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.Logger;

public class MonsterPropertiesManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "monster_properties";
    private Map<ResourceLocation, EntityProperties> propertiesMap = new HashMap<ResourceLocation, EntityProperties>();

    public MonsterPropertiesManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public EntityProperties getPropertiesFor(EntityType<?> type) {
        ResourceLocation res = Registry.f_122826_.m_7981_(type);
        return this.propertiesMap.getOrDefault(res, EntityProperties.DEFAULT_PROP);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder();
        data.forEach((key, el) -> {
            try {
                EntityProperties props = (EntityProperties)EntityProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                propertiesBuilder.put(key, (Object)props);
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldnt parse entity properties json {} {}", key, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.propertiesMap = propertiesBuilder.build();
    }
}

