/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;

public class ShopItemsManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "shop_items";
    private Map<NPCJob, Collection<ShopItemProperties>> shopItems = ImmutableMap.of();
    private Map<NPCJob, Collection<ShopItemProperties>> shopItemsDefaults = ImmutableMap.of();
    private boolean resolved;
    private Map<NPCJob, Collection<ShopItemProperties.IntermediaryShopItem>> intermediaryData = ImmutableMap.of();

    public ShopItemsManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public Collection<ShopItemProperties> get(NPCJob shop) {
        this.resolve();
        return this.shopItems.getOrDefault(shop, Collections.emptyList());
    }

    public Collection<ShopItemProperties> getDefaultItems(NPCJob shop) {
        this.resolve();
        return this.shopItemsDefaults.getOrDefault(shop, Collections.emptyList());
    }

    public void resolve() {
        if (!this.resolved) {
            this.resolved = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder defaultsBuilder = ImmutableMap.builder();
            this.intermediaryData.forEach((job, items) -> {
                ArrayList newCollection = new ArrayList();
                ArrayList defaultCollection = new ArrayList();
                items.forEach(props -> {
                    List<ShopItemProperties> contents = ShopItemProperties.from(props);
                    contents.forEach(prop -> {
                        if (DataPackHandler.INSTANCE.itemStatManager().get(prop.stack().m_41720_()).map(ItemStat::getBuy).orElse(0) > 0) {
                            if (prop.unlockType() == ShopItemProperties.UnlockType.DEFAULT) {
                                defaultCollection.add(prop);
                            } else {
                                newCollection.add(prop);
                            }
                        }
                    });
                });
                builder.put(job, (Object)ImmutableList.copyOf(newCollection));
                defaultsBuilder.put(job, (Object)ImmutableList.copyOf(defaultCollection));
            });
            builder.put((Object)((NPCJob)ModNPCJobs.RANDOM.getSecond()), DataPackHandler.INSTANCE.itemStatManager().all().stream().filter(p -> ((ItemStat)p.getSecond()).getBuy() > 0).map(p -> new ShopItemProperties((ItemStack)p.getFirst(), ShopItemProperties.UnlockType.NEEDS_SHIPPING, EntityPredicate.f_36550_)).toList());
            this.shopItems = builder.build();
            this.shopItemsDefaults = defaultsBuilder.build();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<NPCJob, Collection<ShopItemProperties.IntermediaryShopItem>> shops = new HashMap<NPCJob, Collection<ShopItemProperties.IntermediaryShopItem>>();
        this.resolved = false;
        data.forEach((fres, el) -> {
            try {
                NPCJob shop = ModNPCJobs.getFromID(new ResourceLocation(fres.m_135827_(), fres.m_135815_()));
                if (!shop.hasShop) {
                    return;
                }
                JsonObject obj = el.getAsJsonObject();
                boolean replace = GsonHelper.m_13855_((JsonObject)obj, (String)"replace", (boolean)false);
                JsonArray array = GsonHelper.m_13933_((JsonObject)obj, (String)"values");
                ArrayList contents = new ArrayList();
                array.forEach(val -> {
                    ShopItemProperties.IntermediaryShopItem prop = (ShopItemProperties.IntermediaryShopItem)ShopItemProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                    contents.add(prop);
                });
                if (replace) {
                    shops.put(shop, contents);
                } else {
                    shops.compute(shop, (k, v) -> {
                        if (v == null) {
                            return contents;
                        }
                        v.addAll(contents);
                        return v;
                    });
                }
            }
            catch (JsonSyntaxException ex) {
                RuneCraftory.LOGGER.error("Couldn't parse shop stack json {} {}", fres, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.intermediaryData = shops;
    }
}

